/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.HashSet;
import java.util.Iterator;
import maps.gml.GMLEdge;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import rescuecore2.log.Logger;

public class FixDuplicateEdgesFunction
extends ProgressFunction {
    public FixDuplicateEdgesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Fix duplicate edges";
    }

    @Override
    protected String getTitle() {
        return "Fixing duplicate edges";
    }

    @Override
    protected void executeImpl() {
        HashSet<GMLEdge> remaining = new HashSet<GMLEdge>(this.editor.getMap().getEdges());
        this.setProgressLimit(remaining.size());
        int count = 0;
        while (!remaining.isEmpty()) {
            GMLEdge next = (GMLEdge)remaining.iterator().next();
            remaining.remove(next);
            Iterator it = remaining.iterator();
            while (it.hasNext()) {
                GMLEdge test = (GMLEdge)it.next();
                if (test.getStart() != next.getStart() && test.getStart() != next.getEnd() || test.getEnd() != next.getStart() && test.getEnd() != next.getEnd()) continue;
                this.editor.getMap().replaceEdge(test, next);
                this.editor.getMap().removeEdge(test);
                it.remove();
                ++count;
                this.bumpProgress();
            }
            this.bumpProgress();
        }
        if (count != 0) {
            this.editor.setChanged();
            this.editor.getViewer().repaint();
        }
        Logger.debug((String)("Removed " + count + " duplicate edges"));
    }
}

