/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import maps.gml.GMLBuilding;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.Overlay;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;
import rescuecore2.misc.gui.ScreenTransform;

public class DecoratorOverlay
implements Overlay {
    private transient Map<GMLNode, NodeDecorator> nodeDecorators = new HashMap<GMLNode, NodeDecorator>();
    private transient Map<GMLEdge, EdgeDecorator> edgeDecorators = new HashMap<GMLEdge, EdgeDecorator>();
    private transient Map<GMLBuilding, BuildingDecorator> buildingDecorators = new HashMap<GMLBuilding, BuildingDecorator>();
    private transient Map<GMLRoad, RoadDecorator> roadDecorators = new HashMap<GMLRoad, RoadDecorator>();
    private transient Map<GMLSpace, SpaceDecorator> spaceDecorators = new HashMap<GMLSpace, SpaceDecorator>();

    public void setNodeDecorator(NodeDecorator decorator, GMLNode ... nodes) {
        this.setNodeDecorator(decorator, Arrays.asList(nodes));
    }

    public void setNodeDecorator(NodeDecorator decorator, Collection<? extends GMLNode> nodes) {
        for (GMLNode gMLNode : nodes) {
            this.nodeDecorators.put(gMLNode, decorator);
        }
    }

    public NodeDecorator getNodeDecorator(GMLNode node) {
        NodeDecorator result = this.nodeDecorators.get(node);
        return result;
    }

    public void clearNodeDecorator(GMLNode ... nodes) {
        this.clearNodeDecorator(Arrays.asList(nodes));
    }

    public void clearNodeDecorator(Collection<? extends GMLNode> nodes) {
        for (GMLNode gMLNode : nodes) {
            this.nodeDecorators.remove(gMLNode);
        }
    }

    public void clearAllNodeDecorators() {
        this.nodeDecorators.clear();
    }

    public void setEdgeDecorator(EdgeDecorator decorator, GMLEdge ... edges) {
        this.setEdgeDecorator(decorator, Arrays.asList(edges));
    }

    public void setEdgeDecorator(EdgeDecorator decorator, Collection<? extends GMLEdge> edges) {
        for (GMLEdge gMLEdge : edges) {
            this.edgeDecorators.put(gMLEdge, decorator);
        }
    }

    public EdgeDecorator getEdgeDecorator(GMLEdge edge) {
        EdgeDecorator result = this.edgeDecorators.get(edge);
        return result;
    }

    public void clearEdgeDecorator(GMLEdge ... edges) {
        this.clearEdgeDecorator(Arrays.asList(edges));
    }

    public void clearEdgeDecorator(Collection<? extends GMLEdge> edges) {
        for (GMLEdge gMLEdge : edges) {
            this.edgeDecorators.remove(gMLEdge);
        }
    }

    public void clearAllEdgeDecorators() {
        this.edgeDecorators.clear();
    }

    public void setBuildingDecorator(BuildingDecorator decorator, GMLBuilding ... buildings) {
        this.setBuildingDecorator(decorator, Arrays.asList(buildings));
    }

    public void setBuildingDecorator(BuildingDecorator decorator, Collection<? extends GMLBuilding> buildings) {
        for (GMLBuilding gMLBuilding : buildings) {
            this.buildingDecorators.put(gMLBuilding, decorator);
        }
    }

    public BuildingDecorator getBuildingDecorator(GMLBuilding building) {
        BuildingDecorator result = this.buildingDecorators.get(building);
        return result;
    }

    public void clearBuildingDecorator(GMLBuilding ... buildings) {
        this.clearBuildingDecorator(Arrays.asList(buildings));
    }

    public void clearBuildingDecorator(Collection<? extends GMLBuilding> buildings) {
        for (GMLBuilding gMLBuilding : buildings) {
            this.buildingDecorators.remove(gMLBuilding);
        }
    }

    public void clearAllBuildingDecorators() {
        this.buildingDecorators.clear();
    }

    public void setRoadDecorator(RoadDecorator decorator, GMLRoad ... roads) {
        this.setRoadDecorator(decorator, Arrays.asList(roads));
    }

    public void setRoadDecorator(RoadDecorator decorator, Collection<? extends GMLRoad> roads) {
        for (GMLRoad gMLRoad : roads) {
            this.roadDecorators.put(gMLRoad, decorator);
        }
    }

    public RoadDecorator getRoadDecorator(GMLRoad road) {
        RoadDecorator result = this.roadDecorators.get(road);
        return result;
    }

    public void clearRoadDecorator(GMLRoad ... roads) {
        this.clearRoadDecorator(Arrays.asList(roads));
    }

    public void clearRoadDecorator(Collection<? extends GMLRoad> roads) {
        for (GMLRoad gMLRoad : roads) {
            this.roadDecorators.remove(gMLRoad);
        }
    }

    public void clearAllRoadDecorators() {
        this.roadDecorators.clear();
    }

    public void setSpaceDecorator(SpaceDecorator decorator, GMLSpace ... spaces) {
        this.setSpaceDecorator(decorator, Arrays.asList(spaces));
    }

    public void setSpaceDecorator(SpaceDecorator decorator, Collection<? extends GMLSpace> spaces) {
        for (GMLSpace gMLSpace : spaces) {
            this.spaceDecorators.put(gMLSpace, decorator);
        }
    }

    public SpaceDecorator getSpaceDecorator(GMLSpace space) {
        SpaceDecorator result = this.spaceDecorators.get(space);
        return result;
    }

    public void clearSpaceDecorator(GMLSpace ... spaces) {
        this.clearSpaceDecorator(Arrays.asList(spaces));
    }

    public void clearSpaceDecorator(Collection<? extends GMLSpace> spaces) {
        for (GMLSpace gMLSpace : spaces) {
            this.spaceDecorators.remove(gMLSpace);
        }
    }

    public void clearAllSpaceDecorators() {
        this.spaceDecorators.clear();
    }

    public void clearAllDecorators() {
        this.clearAllBuildingDecorators();
        this.clearAllRoadDecorators();
        this.clearAllSpaceDecorators();
        this.clearAllEdgeDecorators();
        this.clearAllNodeDecorators();
    }

    @Override
    public void render(Graphics2D g, ScreenTransform transform) {
        for (Map.Entry<GMLRoad, RoadDecorator> entry : this.roadDecorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), (Graphics2D)g.create(), transform);
        }
        for (Map.Entry<GMLShape, Object> entry : this.buildingDecorators.entrySet()) {
            ((BuildingDecorator)entry.getValue()).decorate((GMLBuilding)entry.getKey(), (Graphics2D)g.create(), transform);
        }
        for (Map.Entry<GMLShape, Object> entry : this.spaceDecorators.entrySet()) {
            ((SpaceDecorator)entry.getValue()).decorate((GMLSpace)entry.getKey(), (Graphics2D)g.create(), transform);
        }
        for (Map.Entry<GMLObject, Object> entry : this.edgeDecorators.entrySet()) {
            ((EdgeDecorator)entry.getValue()).decorate((GMLEdge)entry.getKey(), (Graphics2D)g.create(), transform);
        }
        for (Map.Entry<GMLObject, Object> entry : this.nodeDecorators.entrySet()) {
            ((NodeDecorator)entry.getValue()).decorate((GMLNode)entry.getKey(), (Graphics2D)g.create(), transform);
        }
    }
}

