/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.Color;
import java.awt.Graphics2D;
import maps.gml.view.Overlay;
import rescuecore2.misc.gui.ScreenTransform;

public class RectangleOverlay
implements Overlay {
    private double left;
    private double right;
    private double bottom;
    private double top;
    private Color colour;
    private boolean useWorldCoords;

    public RectangleOverlay(Color colour, boolean useWorldCoords) {
        this(Double.NaN, Double.NaN, Double.NaN, Double.NaN, colour, useWorldCoords);
    }

    public RectangleOverlay(double left, double right, double top, double bottom, Color colour, boolean useWorldCoords) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.colour = colour;
        this.useWorldCoords = useWorldCoords;
    }

    public void setLeft(double x) {
        this.left = x;
    }

    public void setRight(double x) {
        this.right = x;
    }

    public void setTop(double y) {
        this.top = y;
    }

    public void setBottom(double y) {
        this.bottom = y;
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public void setUseWorldCoordinates(boolean b) {
        this.useWorldCoords = b;
    }

    @Override
    public void render(Graphics2D g, ScreenTransform transform) {
        double y2;
        if (Double.isNaN(this.left) || Double.isNaN(this.right) || Double.isNaN(this.top) || Double.isNaN(this.bottom)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setColor(this.colour);
        double x1 = this.left < this.right ? this.left : this.right;
        double x2 = this.left < this.right ? this.right : this.left;
        double y1 = this.bottom < this.top ? this.bottom : this.top;
        double d = y2 = this.bottom < this.top ? this.top : this.bottom;
        if (this.useWorldCoords) {
            x1 = transform.xToScreen(x1);
            x2 = transform.xToScreen(x2);
            double temp = transform.yToScreen(y2);
            y2 = transform.yToScreen(y1);
            y1 = temp;
        }
        graphics.fillRect((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }
}

