/*
 * Decompiled with CFR 0.152.
 */
package maps.osm;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import maps.osm.OSMBuilding;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import maps.osm.OSMRoad;
import rescuecore2.misc.gui.PanZoomListener;
import rescuecore2.misc.gui.ScreenTransform;

public class OSMMapViewer
extends JComponent {
    private OSMMap map;
    private ScreenTransform transform;
    private PanZoomListener panZoom = new PanZoomListener((JComponent)this);

    public OSMMapViewer() {
        this(null);
    }

    public OSMMapViewer(final OSMMap map) {
        this.setMap(map);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Point p = e.getPoint();
                    double lon = OSMMapViewer.this.transform.screenToX(p.x);
                    double lat = OSMMapViewer.this.transform.screenToY(p.y);
                    OSMNode node = map.getNearestNode(lat, lon);
                    System.out.println("Click at " + lat + ", " + lon);
                    System.out.println("Nearest node: " + node);
                }
            }
        });
    }

    public void setMap(OSMMap map) {
        this.map = map;
        this.transform = null;
        if (map != null) {
            this.transform = new ScreenTransform(map.getMinLongitude(), map.getMinLatitude(), map.getMaxLongitude(), map.getMaxLatitude());
        }
        this.panZoom.setScreenTransform(this.transform);
    }

    public double getLatitude(int y) {
        return this.transform.screenToY(y);
    }

    public double getLongitude(int x) {
        return this.transform.screenToX(x);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int y;
        int x;
        OSMNode node;
        int lastY;
        int lastX;
        super.paintComponent(graphics);
        if (this.map == null) {
            return;
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g = (Graphics2D)graphics.create(insets.left, insets.top, width + 1, height + 1);
        this.transform.rescale(width, height);
        g.setColor(Color.black);
        for (OSMNode oSMNode : this.map.getNodes()) {
            int x2 = this.transform.xToScreen(oSMNode.getLongitude());
            int y2 = this.transform.yToScreen(oSMNode.getLatitude());
            g.drawLine(x2 - 1, y2 - 1, x2 + 1, y2 + 1);
            g.drawLine(x2 + 1, y2 - 1, x2 - 1, y2 + 1);
        }
        for (OSMRoad oSMRoad : this.map.getRoads()) {
            lastX = -1;
            lastY = -1;
            for (Long nodeID : oSMRoad.getNodeIDs()) {
                node = this.map.getNode(nodeID);
                x = this.transform.xToScreen(node.getLongitude());
                y = this.transform.yToScreen(node.getLatitude());
                if (lastX != -1) {
                    g.drawLine(lastX, lastY, x, y);
                }
                lastX = x;
                lastY = y;
            }
        }
        g.setColor(Color.blue);
        for (OSMBuilding oSMBuilding : this.map.getBuildings()) {
            lastX = -1;
            lastY = -1;
            for (Long nodeID : oSMBuilding.getNodeIDs()) {
                node = this.map.getNode(nodeID);
                x = this.transform.xToScreen(node.getLongitude());
                y = this.transform.yToScreen(node.getLatitude());
                if (lastX != -1) {
                    g.drawLine(lastX, lastY, x, y);
                }
                lastX = x;
                lastY = y;
            }
        }
    }
}

