/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.misc.EncodingTools;

public class CommandListComponent
extends AbstractMessageComponent {
    private List<Command> commands;

    public CommandListComponent(String name) {
        super(name);
        this.commands = new ArrayList<Command>();
    }

    public CommandListComponent(String name, Collection<? extends Command> commands) {
        super(name);
        this.commands = new ArrayList<Command>(commands);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(Collection<? extends Command> commands) {
        this.commands = new ArrayList<Command>(commands);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.commands.size(), out);
        for (Command next : this.commands) {
            EncodingTools.writeMessage((Message)next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.commands.clear();
        int size = EncodingTools.readInt32(in);
        for (int i = 0; i < size; ++i) {
            Message m = EncodingTools.readMessage(in);
            if (!(m instanceof Command)) {
                throw new IOException("Command list stream contained a non-command message: " + m + " (" + m.getClass().getName() + ")");
            }
            this.commands.add((Command)m);
        }
    }

    public String toString() {
        return this.commands.size() + " commands";
    }
}

