/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry.spatialindex;

import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.spatialindex.LineRegion;
import rescuecore2.misc.geometry.spatialindex.RectangleRegion;
import rescuecore2.misc.geometry.spatialindex.Region;
import rescuecore2.misc.geometry.spatialindex.Tools;

public class PointRegion
implements Region {
    private double x;
    private double y;
    private Point2D point;

    public PointRegion(double x, double y) {
        this.x = x;
        this.y = y;
        this.point = null;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D getPoint() {
        if (this.point == null) {
            this.point = new Point2D(this.x, this.y);
        }
        return this.point;
    }

    @Override
    public double getXMin() {
        return this.x;
    }

    @Override
    public double getYMin() {
        return this.y;
    }

    @Override
    public double getXMax() {
        return this.x;
    }

    @Override
    public double getYMax() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (o instanceof PointRegion) {
            PointRegion p = (PointRegion)o;
            return Tools.equal(this.x, p.x) && Tools.equal(this.y, p.y);
        }
        return false;
    }

    public int hashCode() {
        Double d = this.x + this.y;
        return d.hashCode();
    }

    public String toString() {
        return "Point region: " + this.x + ", " + this.y;
    }

    @Override
    public boolean intersects(Region r) {
        if (r instanceof RectangleRegion) {
            RectangleRegion rect = (RectangleRegion)r;
            return this.x >= rect.getXMin() && this.x <= rect.getXMax() && this.y >= rect.getYMin() && this.y <= rect.getYMax();
        }
        if (r instanceof LineRegion) {
            LineRegion l = (LineRegion)r;
            return GeometryTools2D.contains(l.getLine(), this.getPoint());
        }
        if (r instanceof PointRegion) {
            return this.equals(r);
        }
        return false;
    }

    @Override
    public boolean contains(Region r) {
        return false;
    }
}

