/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ListModelList<T>
extends AbstractListModel
implements List<T>,
ListModel {
    private List<T> downstream;

    public ListModelList() {
        this(new ArrayList());
    }

    public ListModelList(List<T> downstream) {
        this.downstream = downstream;
    }

    public Object getElementAt(int index) {
        return this.downstream.get(index);
    }

    @Override
    public int getSize() {
        return this.downstream.size();
    }

    @Override
    public boolean add(T t) {
        boolean result = this.downstream.add(t);
        if (result) {
            this.fireIntervalAdded(this, Math.max(0, this.downstream.size() - 1), Math.max(0, this.downstream.size() - 1));
        }
        return result;
    }

    @Override
    public void add(int index, T element) {
        this.downstream.add(index, element);
        this.fireContentsChanged(this, index, Math.max(0, this.downstream.size() - 1));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int oldSize = this.downstream.size();
        boolean result = this.downstream.addAll(c);
        this.fireIntervalAdded(this, oldSize, Math.max(0, this.downstream.size() - 1));
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = this.downstream.addAll(index, c);
        this.fireContentsChanged(this, index, Math.max(0, this.downstream.size() - 1));
        return result;
    }

    @Override
    public void clear() {
        int size = this.downstream.size();
        this.downstream.clear();
        this.fireIntervalRemoved(this, 0, Math.max(0, size - 1));
    }

    @Override
    public boolean contains(Object o) {
        return this.downstream.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.downstream.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.downstream.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.downstream.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.downstream.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new NotifyingIterator<T>(this.downstream.iterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.downstream.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NotifyingListIterator<T>(this.downstream.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new NotifyingListIterator<T>(this.downstream.listIterator(index), index);
    }

    @Override
    public T remove(int index) {
        T result = this.downstream.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        boolean result = this.downstream.remove(o);
        if (result) {
            this.fireIntervalRemoved(this, index, index);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int oldSize = this.downstream.size();
        boolean result = this.downstream.removeAll(c);
        if (result) {
            this.fireIntervalRemoved(this, this.downstream.size(), Math.max(0, oldSize - 1));
            this.fireContentsChanged(this, 0, Math.max(0, this.downstream.size() - 1));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = this.downstream.size();
        boolean result = this.downstream.retainAll(c);
        if (result) {
            this.fireIntervalRemoved(this, this.downstream.size(), Math.max(0, oldSize - 1));
            this.fireContentsChanged(this, 0, Math.max(0, this.downstream.size() - 1));
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        T result = this.downstream.set(index, element);
        this.fireContentsChanged(this, index, index);
        return result;
    }

    @Override
    public int size() {
        return this.downstream.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ListModelList<T> sublist = new ListModelList<T>(this.downstream.subList(fromIndex, toIndex));
        for (ListDataListener l : this.getListDataListeners()) {
            sublist.addListDataListener(l);
        }
        return sublist;
    }

    @Override
    public Object[] toArray() {
        return this.downstream.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.downstream.toArray(a);
    }

    private class NotifyingListIterator<T>
    implements ListIterator<T> {
        private int index;
        private ListIterator<T> downstream;

        NotifyingListIterator(ListIterator<T> downstream) {
            this(downstream, 0);
        }

        NotifyingListIterator(ListIterator<T> downstream, int index) {
            this.index = index;
            this.downstream = downstream;
        }

        @Override
        public void add(T t) {
            this.downstream.add(t);
            ++this.index;
            ListModelList.this.fireIntervalAdded(ListModelList.this, this.index, this.index);
        }

        @Override
        public boolean hasNext() {
            return this.downstream.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.downstream.hasPrevious();
        }

        @Override
        public T next() {
            T result = this.downstream.next();
            ++this.index;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.downstream.nextIndex();
        }

        @Override
        public T previous() {
            T result = this.downstream.previous();
            --this.index;
            return result;
        }

        @Override
        public int previousIndex() {
            return this.downstream.previousIndex();
        }

        @Override
        public void remove() {
            this.downstream.remove();
            ListModelList.this.fireIntervalRemoved(ListModelList.this, this.index, this.index);
        }

        @Override
        public void set(T t) {
            this.downstream.set(t);
            ListModelList.this.fireContentsChanged(ListModelList.this, this.index, this.index);
        }
    }

    private class NotifyingIterator<T>
    implements Iterator<T> {
        private int index = 0;
        private Iterator<T> downstream;

        NotifyingIterator(Iterator<T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public boolean hasNext() {
            return this.downstream.hasNext();
        }

        @Override
        public T next() {
            T result = this.downstream.next();
            ++this.index;
            return result;
        }

        @Override
        public void remove() {
            this.downstream.remove();
            ListModelList.this.fireIntervalRemoved(ListModelList.this, this.index, this.index);
        }
    }
}

