/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.score;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rescuecore2.config.Config;
import rescuecore2.score.AbstractScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public abstract class CompositeScoreFunction
extends AbstractScoreFunction {
    protected Set<ScoreFunction> children = new HashSet<ScoreFunction>();

    public CompositeScoreFunction(String name) {
        super(name);
    }

    public CompositeScoreFunction(String name, Collection<ScoreFunction> c) {
        this(name);
        this.addChildFunctions(c);
    }

    public CompositeScoreFunction(String name, ScoreFunction ... c) {
        this(name);
        this.addChildFunctions(c);
    }

    public void addChildFunction(ScoreFunction child) {
        this.children.add(child);
    }

    public final void addChildFunctions(Collection<ScoreFunction> c) {
        for (ScoreFunction next : c) {
            this.addChildFunction(next);
        }
    }

    public final void addChildFunctions(ScoreFunction ... c) {
        for (ScoreFunction next : c) {
            this.addChildFunction(next);
        }
    }

    public void removeChildFunction(ScoreFunction child) {
        this.children.remove(child);
    }

    public final void removeChildFunctions(Collection<ScoreFunction> c) {
        for (ScoreFunction next : c) {
            this.removeChildFunction(next);
        }
    }

    public final void removeChildFunctions(ScoreFunction ... c) {
        for (ScoreFunction next : c) {
            this.removeChildFunction(next);
        }
    }

    @Override
    public void initialise(WorldModel<? extends Entity> world, Config config) {
        for (ScoreFunction next : this.children) {
            next.initialise(world, config);
        }
    }

    public Set<ScoreFunction> getChildFunctions() {
        return Collections.unmodifiableSet(this.children);
    }
}

