/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.util.Configuration;
import firesimulator.world.Building;
import firesimulator.world.FireBrigade;
import firesimulator.world.MovingObject;
import firesimulator.world.RescueObject;
import firesimulator.world.Wall;
import firesimulator.world.WorldConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class World
implements WorldConstants {
    private static final Log LOG = LogFactory.getLog(World.class);
    private Hashtable pool;
    private Collection extinguishRequests;
    private int time;
    private Collection updatelist;
    private Collection<Building> buildings;
    private Collection firebrigades;
    private int maxX;
    private int maxY;
    private int minX;
    private int minY;
    private double[][] airTemp;
    public ArrayList[][] gridToBuilding;
    public int SAMPLE_SIZE = 5000;
    public float AIR_CAPACITY = 0.2f;
    public float AIR_HEIGHT = 30.0f;
    public int CAPACITY;
    public float maxDist;
    private boolean isInitialized;
    public Collection allWalls;
    private Long hashValue;
    private static World me;

    public World() {
        me = this;
        this.hashValue = null;
        this.pool = new Hashtable();
        this.allWalls = new LinkedList();
        this.extinguishRequests = new LinkedList();
        this.updatelist = new LinkedList();
        this.firebrigades = new HashSet();
        this.buildings = new HashSet<Building>();
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.isInitialized = false;
    }

    public static World getWorld() {
        return me;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public Iterator getExtinguishIterator() {
        return this.extinguishRequests.iterator();
    }

    public void addExtinguishRequest(Object request) {
        this.extinguishRequests.add(request);
    }

    public void clearExtinguishRequests() {
        this.extinguishRequests.clear();
        for (FireBrigade fb : this.firebrigades) {
            fb.nextCycle();
        }
    }

    public boolean isIntialized() {
        return this.isInitialized;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    private void loadVars() {
        this.SAMPLE_SIZE = new Integer(Configuration.getValue("resq-fire.cell_size"));
        Building.concreteBurning = new Float(Configuration.getValue("resq-fire.concrete_burning")).floatValue();
        Building.concreteCapacity = new Float(Configuration.getValue("resq-fire.concrete_capacity")).floatValue();
        Building.concreteEnergie = new Float(Configuration.getValue("resq-fire.concrete_energy")).floatValue();
        Building.concreteIgnition = new Float(Configuration.getValue("resq-fire.concrete_ignition")).floatValue();
        Building.concreteSpeed = new Float(Configuration.getValue("resq-fire.concrete_speed")).floatValue();
        Building.steelBurning = new Float(Configuration.getValue("resq-fire.steel_burning")).floatValue();
        Building.steelCapacity = new Float(Configuration.getValue("resq-fire.steel_capacity")).floatValue();
        Building.steelEnergie = new Float(Configuration.getValue("resq-fire.steel_energy")).floatValue();
        Building.steelIgnition = new Float(Configuration.getValue("resq-fire.steel_ignition")).floatValue();
        Building.steelSpeed = new Float(Configuration.getValue("resq-fire.steel_speed")).floatValue();
        Building.woodBurning = new Float(Configuration.getValue("resq-fire.wooden_burning")).floatValue();
        Building.woodCapacity = new Float(Configuration.getValue("resq-fire.wooden_capacity")).floatValue();
        Building.woodEnergie = new Float(Configuration.getValue("resq-fire.wooden_energy")).floatValue();
        Building.woodIgnition = new Float(Configuration.getValue("resq-fire.wooden_ignition")).floatValue();
        Building.woodSpeed = new Float(Configuration.getValue("resq-fire.wooden_speed")).floatValue();
        Building.FIRE_INFALMEABLE = new Boolean(Configuration.getValue("resq-fire.fire_station_inflammable"));
        Building.AMBULANCE_INFALMEABLE = new Boolean(Configuration.getValue("resq-fire.ambulance_center_inflammable"));
        Building.POLICE_INFALMEABLE = new Boolean(Configuration.getValue("resq-fire.police_office_inflammable"));
        Building.REFUGE_INFALMEABLE = new Boolean(Configuration.getValue("resq-fire.refuge_inflammable"));
        Wall.RAY_RATE = new Float(Configuration.getValue("resq-fire.ray_rate")).floatValue();
        Wall.MAX_SAMPLE_DISTANCE = new Integer(Configuration.getValue("resq-fire.max_ray_distance"));
        FireBrigade.REFILL_QUANTITY = new Integer(Configuration.getValue("resq-fire.water_refill_rate"));
        FireBrigade.MAX_WATER_QUANTITY = new Integer(Configuration.getValue("resq-fire.water_capacity"));
    }

    public void initialize() {
        LOG.info((Object)"World initialising");
        this.loadVars();
        this.allWalls.clear();
        this.clearExtinguishRequests();
        this.initializeBuildings();
        this.initializeAir();
        this.igniteGISFires();
        this.isInitialized = true;
        LOG.info((Object)"World initialised");
    }

    private void initializeBuildings() {
        for (Building b : this.buildings) {
            int[] ap = b.getApexes();
            for (int n = 0; n < ap.length; ++n) {
                if (ap[n] > this.maxX) {
                    this.maxX = ap[n];
                }
                if (ap[n] < this.minX) {
                    this.minX = ap[n];
                }
                if (ap[++n] > this.maxY) {
                    this.maxY = ap[n];
                }
                if (ap[n] >= this.minY) continue;
                this.minY = ap[n];
            }
            b.initialize(this);
        }
        this.maxDist = (float)Math.sqrt((this.maxX - this.minX) * (this.maxX - this.minX) + (this.maxY - this.minY) * (this.maxY - this.minY));
        this.initRayValues();
    }

    private void initRayValues() {
        File f;
        long hash = this.hash();
        boolean loaded = false;
        String fname = Configuration.getValue("resq-fire.rays.dir") + "/" + hash + ".rays";
        try {
            String nl;
            f = new File(fname);
            BufferedReader br = new BufferedReader(new FileReader(f));
            float rayDens = Float.parseFloat(br.readLine());
            while (null != (nl = br.readLine())) {
                int x = Integer.parseInt(nl);
                int y = Integer.parseInt(br.readLine());
                int quantity = Integer.parseInt(br.readLine());
                Building[] bl = new Building[quantity];
                float[] wght = new float[quantity];
                for (int c = 0; c < quantity; ++c) {
                    int ox = Integer.parseInt(br.readLine());
                    int oy = Integer.parseInt(br.readLine());
                    bl[c] = this.getBuilding(ox, oy);
                    wght[c] = Float.parseFloat(br.readLine());
                }
                Building b = this.getBuilding(x, y);
                b.connectedBuilding = bl;
                b.connectedValues = wght;
            }
            loaded = true;
            LOG.info((Object)("loaded radiation sample file \"" + fname + "\""));
        }
        catch (Exception e) {
            LOG.warn((Object)("unable to load radiation sample file \"" + fname + "\", sampling:"));
            int n = 0;
            long t1 = System.currentTimeMillis();
            for (Building b : this.buildings) {
                LOG.info((Object)("building " + b.getID() + " (" + n++ + " of " + this.buildings.size() + ") "));
                b.initWallValues(this);
                long dt = System.currentTimeMillis() - t1;
                dt /= (long)n;
                long sec = (dt *= (long)(this.buildings.size() - n)) / 1000L;
                long min = sec / 60L % 60L;
                long hour = sec / 3600L;
                LOG.info((Object)(" time left: ca. " + hour + ":" + min + ":" + (sec %= 60L)));
            }
        }
        try {
            if (!loaded) {
                f = new File(fname);
                f.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(Wall.RAY_RATE + "\n");
                for (Building b : this.buildings) {
                    bw.write(b.getX() + "\n");
                    bw.write(b.getY() + "\n");
                    bw.write(b.connectedBuilding.length + "\n");
                    for (int c = 0; c < b.connectedBuilding.length; ++c) {
                        bw.write(b.connectedBuilding[c].getX() + "\n");
                        bw.write(b.connectedBuilding[c].getY() + "\n");
                        bw.write(b.connectedValues[c] + "\n");
                    }
                }
                bw.close();
                LOG.info((Object)("wrote radiation sample file \"" + fname + "\""));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("error while writting radiation sample file \"" + fname + "\""), (Throwable)e);
        }
    }

    private Building getBuilding(int x, int y) {
        for (Building b : this.buildings) {
            if (!b.isBuilding(x, y)) continue;
            return b;
        }
        LOG.error((Object)"parser error");
        throw new NullPointerException();
    }

    public float getMaxDistance() {
        return this.maxDist;
    }

    private void initializeAir() {
        int y;
        int x;
        LOG.info((Object)("World width: " + (this.maxX - this.minX) + "mm"));
        LOG.info((Object)("World height: " + (this.maxY - this.minY) + "mm"));
        int xSamples = 1 + (this.maxX - this.minX) / this.SAMPLE_SIZE;
        int ySamples = 1 + (this.maxY - this.minY) / this.SAMPLE_SIZE;
        LOG.info((Object)("grid cell size=" + this.SAMPLE_SIZE + "mm, x*y=" + xSamples + "*" + ySamples + " = " + xSamples * ySamples));
        this.airTemp = new double[xSamples][ySamples];
        for (x = 0; x < this.airTemp.length; ++x) {
            for (y = 0; y < this.airTemp[x].length; ++y) {
                this.airTemp[x][y] = 0.0;
            }
        }
        this.CAPACITY = (int)((float)(this.SAMPLE_SIZE * this.SAMPLE_SIZE) * this.AIR_HEIGHT * this.AIR_CAPACITY) / 1000000;
        this.gridToBuilding = new ArrayList[xSamples][ySamples];
        for (x = 0; x < this.gridToBuilding.length; ++x) {
            for (y = 0; y < this.gridToBuilding[0].length; ++y) {
                this.gridToBuilding[x][y] = new ArrayList();
            }
        }
        for (Building b : this.buildings) {
            b.findCells(this);
        }
    }

    public double[][] getAirTemp() {
        return this.airTemp;
    }

    public void setAirTemp(double[][] a) {
        this.airTemp = a;
    }

    public void setAirCellTemp(int x, int y, double temp) {
        this.airTemp[x][y] = temp;
    }

    public double getAirCellTemp(int x, int y) {
        return this.airTemp[x][y];
    }

    public Collection<Building> getBuildings() {
        return this.buildings;
    }

    public void addUpdate(RescueObject obj) {
        this.updatelist.add(obj);
    }

    public void clearUpdates() {
        this.updatelist.clear();
    }

    public Collection getUpdates() {
        return this.updatelist;
    }

    public int countObjects() {
        return this.pool.size();
    }

    public int getTime() {
        return this.time;
    }

    public RescueObject getObject(int ID) {
        return (RescueObject)this.pool.get(new Integer(ID));
    }

    public void putObject(RescueObject obj) {
        this.pool.put(new Integer(obj.getID()), obj);
        if (obj instanceof FireBrigade) {
            this.firebrigades.add(obj);
        }
        if (obj instanceof Building) {
            this.buildings.add((Building)obj);
        }
        if (obj instanceof MovingObject) {
            ((MovingObject)obj).setWorld(this);
        }
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void reset() {
        this.loadVars();
        this.setTime(0);
        this.resetAir();
        Iterator<Building> i = this.buildings.iterator();
        while (i.hasNext()) {
            i.next().reset(this);
        }
        i = this.firebrigades.iterator();
        while (i.hasNext()) {
            ((FireBrigade)((Object)i.next())).reset();
        }
        this.igniteGISFires();
    }

    private void resetAir() {
        for (int x = 0; x < this.airTemp.length; ++x) {
            for (int y = 0; y < this.airTemp[x].length; ++y) {
                this.airTemp[x][y] = 0.0;
            }
        }
    }

    public void igniteGISFires() {
        for (Building b : this.getBuildings()) {
            if (b.getIgnition() == 0) continue;
            b.ignite();
            this.addUpdate(b);
        }
    }

    public Collection getFirebrigades() {
        return this.firebrigades;
    }

    public void setFirebrigades(Collection collection) {
        this.firebrigades = collection;
    }

    public void printSummary() {
        LOG.debug((Object)("objects total: " + this.countObjects()));
    }

    public long hash() {
        if (this.hashValue == null) {
            long sum = 0L;
            for (Building b : this.buildings) {
                int[] ap = b.getApexes();
                for (int c = 0; c < ap.length; ++c) {
                    if (Long.MAX_VALUE - sum <= (long)ap[c]) {
                        sum = 0L;
                    }
                    sum += (long)ap[c];
                }
            }
            this.hashValue = new Long(sum);
        }
        return this.hashValue;
    }
}

