/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.GaussianGenerator;
import rescuecore2.config.Config;

public class DamageType {
    private String type;
    private double k;
    private double l;
    private Random random;
    private NumberGenerator<Double> noise;
    private double damage;

    public DamageType(String type, Config config) {
        this.type = type;
        this.k = config.getFloatValue("misc.injury." + type + ".k");
        this.l = config.getFloatValue("misc.injury." + type + ".l");
        double mean = config.getFloatValue("misc.injury." + type + ".noise.mean");
        double sd = config.getFloatValue("misc.injury." + type + ".noise.sd");
        this.random = config.getRandom();
        this.noise = new GaussianGenerator(mean, sd, this.random);
        this.damage = 0.0;
    }

    public String getType() {
        return this.type;
    }

    public double progress() {
        if (this.damage <= 0.0) {
            return this.damage;
        }
        double n = (Double)this.noise.nextValue();
        this.damage = this.damage + this.k * this.damage * this.damage + this.l + n;
        return this.damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double d) {
        this.damage = d;
    }

    public void addDamage(double d) {
        this.damage += d;
    }
}

