/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kernel.CommunicationModel;
import kernel.Perception;
import kernel.WorldModelCreator;
import rescuecore2.components.Agent;
import rescuecore2.components.Component;
import rescuecore2.components.Simulator;
import rescuecore2.components.Viewer;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.misc.java.JavaTools;

public class KernelStartupOptions {
    private static final String AUTO_SUFFIX = ".auto";
    private List<WorldModelCreator> worldOptions;
    private List<Perception> perceptionOptions;
    private List<CommunicationModel> commsOptions;
    private Map<Simulator, Integer> sims;
    private Map<Viewer, Integer> viewers;
    private Map<Agent, Integer> agents;
    private Map<Component, Integer> other;
    private WorldModelCreator world;
    private Perception perception;
    private CommunicationModel comms;

    public KernelStartupOptions(Config config) {
        Pair<List<WorldModelCreator>, Integer> w = this.createOptions(config, "kernel.gis", WorldModelCreator.class);
        this.worldOptions = (List)w.first();
        this.world = this.worldOptions.get((Integer)w.second());
        Pair<List<Perception>, Integer> p = this.createOptions(config, "kernel.perception", Perception.class);
        this.perceptionOptions = (List)p.first();
        this.perception = this.perceptionOptions.get((Integer)p.second());
        Pair<List<CommunicationModel>, Integer> c = this.createOptions(config, "kernel.communication", CommunicationModel.class);
        this.commsOptions = (List)c.first();
        this.comms = this.commsOptions.get((Integer)c.second());
        this.sims = this.createComponentOptions(config, "kernel.simulators", Simulator.class);
        this.viewers = this.createComponentOptions(config, "kernel.viewers", Viewer.class);
        this.agents = this.createComponentOptions(config, "kernel.agents", Agent.class);
        this.other = this.createComponentOptions(config, "kernel.components", Component.class);
    }

    public Collection<Pair<String, Integer>> getInlineComponents() {
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        for (Map.Entry<Simulator, Integer> entry : this.sims.entrySet()) {
            result.add(new Pair((Object)entry.getKey().getClass().getName(), (Object)entry.getValue()));
        }
        for (Map.Entry<Simulator, Integer> entry : this.viewers.entrySet()) {
            result.add(new Pair((Object)((Viewer)entry.getKey()).getClass().getName(), (Object)entry.getValue()));
        }
        for (Map.Entry<Simulator, Integer> entry : this.agents.entrySet()) {
            result.add((Pair<String, Integer>)new Pair((Object)((Agent)entry.getKey()).getClass().getName(), (Object)entry.getValue()));
        }
        for (Map.Entry<Simulator, Integer> entry : this.other.entrySet()) {
            result.add((Pair<String, Integer>)new Pair((Object)((Component)entry.getKey()).getClass().getName(), (Object)entry.getValue()));
        }
        return result;
    }

    public WorldModelCreator getWorldModelCreator() {
        return this.world;
    }

    public void setWorldModelCreator(WorldModelCreator creator) {
        this.world = creator;
    }

    public List<WorldModelCreator> getAvailableWorldModelCreators() {
        return Collections.unmodifiableList(this.worldOptions);
    }

    public Perception getPerception() {
        return this.perception;
    }

    public void setPerception(Perception p) {
        this.perception = p;
    }

    public List<Perception> getAvailablePerceptions() {
        return Collections.unmodifiableList(this.perceptionOptions);
    }

    public CommunicationModel getCommunicationModel() {
        return this.comms;
    }

    public void setCommunicationModel(CommunicationModel c) {
        this.comms = c;
    }

    public List<CommunicationModel> getAvailableCommunicationModels() {
        return Collections.unmodifiableList(this.commsOptions);
    }

    public Collection<Simulator> getAvailableSimulators() {
        return Collections.unmodifiableSet(this.sims.keySet());
    }

    public Collection<Viewer> getAvailableViewers() {
        return Collections.unmodifiableSet(this.viewers.keySet());
    }

    public Collection<Agent> getAvailableAgents() {
        return Collections.unmodifiableSet(this.agents.keySet());
    }

    public Collection<Component> getAvailableComponents() {
        return Collections.unmodifiableSet(this.other.keySet());
    }

    public int getInstanceCount(Component c) {
        if (this.sims.containsKey(c)) {
            return this.sims.get(c);
        }
        if (this.viewers.containsKey(c)) {
            return this.viewers.get(c);
        }
        if (this.agents.containsKey(c)) {
            return this.agents.get(c);
        }
        if (this.other.containsKey(c)) {
            return this.other.get(c);
        }
        throw new IllegalArgumentException("Component " + c + " not recognised");
    }

    public void setInstanceCount(Component c, int count) {
        if (c instanceof Simulator) {
            this.sims.put((Simulator)c, count);
        } else if (c instanceof Viewer) {
            this.viewers.put((Viewer)c, count);
        } else if (c instanceof Agent) {
            this.agents.put((Agent)c, count);
        } else {
            this.other.put(c, count);
        }
    }

    private <T> Pair<List<T>, Integer> createOptions(Config config, String key, Class<T> expectedClass) {
        ArrayList<Object> instances = new ArrayList<Object>();
        int index = 0;
        int selectedIndex = 0;
        Logger.trace((String)("Loading options: " + key));
        List classNames = config.getArrayValue(key);
        String auto = config.getValue(key + AUTO_SUFFIX, null);
        boolean autoFound = false;
        for (String next : classNames) {
            Logger.trace((String)("Option found: '" + next + "'"));
            Object t = JavaTools.instantiate((String)next, expectedClass);
            if (t == null) continue;
            instances.add(t);
            if (next.equals(auto)) {
                selectedIndex = index;
                autoFound = true;
            }
            ++index;
        }
        if (auto != null && !autoFound) {
            Logger.warn((String)("Could not find class " + auto + " in config key " + key + ". Values found: " + classNames));
        }
        return new Pair(instances, (Object)selectedIndex);
    }

    private <T> Map<T, Integer> createComponentOptions(Config config, String key, Class<T> expectedClass) {
        Logger.trace((String)("Loading component options: " + key));
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        List classNames = config.getArrayValue(key, "");
        List autoClassNames = config.getArrayValue(key + AUTO_SUFFIX, "");
        HashSet<String> allClassNames = new HashSet<String>(classNames);
        allClassNames.addAll(this.strip(autoClassNames));
        for (String next : allClassNames) {
            Logger.trace((String)("Option found: '" + next + "'"));
            Object t = JavaTools.instantiate((String)next, expectedClass);
            if (t == null) continue;
            int count = this.getStartCount(next, autoClassNames);
            result.put(t, count);
        }
        return result;
    }

    private int getStartCount(String className, List<String> auto) {
        for (String next : auto) {
            if (!next.startsWith(className)) continue;
            int index = next.indexOf("*");
            if (index == -1) {
                return 1;
            }
            String arg = next.substring(index + 1);
            if ("n".equals(arg)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(arg);
        }
        return 0;
    }

    private List<String> strip(List<String> autoClassNames) {
        ArrayList<String> result = new ArrayList<String>(autoClassNames.size());
        for (String s : autoClassNames) {
            int index = s.indexOf("*");
            if (index != -1) {
                result.add(s.substring(0, index));
                continue;
            }
            result.add(s);
        }
        return result;
    }
}

