/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.index.kdtree.KdNode;
import com.vividsolutions.jts.index.kdtree.KdTree;
import com.vividsolutions.jts.triangulate.ConstraintEnforcementException;
import com.vividsolutions.jts.triangulate.ConstraintSplitPointFinder;
import com.vividsolutions.jts.triangulate.ConstraintVertex;
import com.vividsolutions.jts.triangulate.ConstraintVertexFactory;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.NonEncroachingSplitPointFinder;
import com.vividsolutions.jts.triangulate.Segment;
import com.vividsolutions.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import com.vividsolutions.jts.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ConformingDelaunayTriangulator {
    private List initialVertices;
    private List segVertices;
    private List segments = new ArrayList();
    private QuadEdgeSubdivision subdiv = null;
    private IncrementalDelaunayTriangulator incDel;
    private Geometry convexHull;
    private ConstraintSplitPointFinder splitFinder = new NonEncroachingSplitPointFinder();
    private KdTree kdt = null;
    private ConstraintVertexFactory vertexFactory = null;
    private Envelope computeAreaEnv;
    private Coordinate splitPt = null;
    private double tolerance;
    private static final int MAX_SPLIT_ITER = 99;

    private static Envelope computeVertexEnvelope(Collection vertices) {
        Envelope env = new Envelope();
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            Vertex v = (Vertex)i.next();
            env.expandToInclude(v.getCoordinate());
        }
        return env;
    }

    public ConformingDelaunayTriangulator(Collection initialVertices, double tolerance) {
        this.initialVertices = new ArrayList(initialVertices);
        this.tolerance = tolerance;
        this.kdt = new KdTree(tolerance);
    }

    public void setConstraints(List segments, List segVertices) {
        this.segments = segments;
        this.segVertices = segVertices;
    }

    public void setSplitPointFinder(ConstraintSplitPointFinder splitFinder) {
        this.splitFinder = splitFinder;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public ConstraintVertexFactory getVertexFactory() {
        return this.vertexFactory;
    }

    public void setVertexFactory(ConstraintVertexFactory vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    public QuadEdgeSubdivision getSubdivision() {
        return this.subdiv;
    }

    public KdTree getKDT() {
        return this.kdt;
    }

    public List getInitialVertices() {
        return this.initialVertices;
    }

    public Collection getConstraintSegments() {
        return this.segments;
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    private void computeBoundingBox() {
        Envelope vertexEnv = ConformingDelaunayTriangulator.computeVertexEnvelope(this.initialVertices);
        Envelope segEnv = ConformingDelaunayTriangulator.computeVertexEnvelope(this.segVertices);
        Envelope allPointsEnv = new Envelope(vertexEnv);
        allPointsEnv.expandToInclude(segEnv);
        double deltaX = allPointsEnv.getWidth() * 0.2;
        double deltaY = allPointsEnv.getHeight() * 0.2;
        double delta = Math.max(deltaX, deltaY);
        this.computeAreaEnv = new Envelope(allPointsEnv);
        this.computeAreaEnv.expandBy(delta);
    }

    private void computeConvexHull() {
        GeometryFactory fact = new GeometryFactory();
        Coordinate[] coords = this.getPointArray();
        ConvexHull hull = new ConvexHull(coords, fact);
        this.convexHull = hull.getConvexHull();
    }

    private Coordinate[] getPointArray() {
        Vertex v;
        Coordinate[] pts = new Coordinate[this.initialVertices.size() + this.segVertices.size()];
        int index = 0;
        Iterator i = this.initialVertices.iterator();
        while (i.hasNext()) {
            v = (Vertex)i.next();
            pts[index++] = v.getCoordinate();
        }
        Iterator i2 = this.segVertices.iterator();
        while (i2.hasNext()) {
            v = (Vertex)i2.next();
            pts[index++] = v.getCoordinate();
        }
        return pts;
    }

    private ConstraintVertex createVertex(Coordinate p) {
        ConstraintVertex v = null;
        v = this.vertexFactory != null ? this.vertexFactory.createVertex(p, null) : new ConstraintVertex(p);
        return v;
    }

    private ConstraintVertex createVertex(Coordinate p, Segment seg) {
        ConstraintVertex v = null;
        v = this.vertexFactory != null ? this.vertexFactory.createVertex(p, seg) : new ConstraintVertex(p);
        v.setOnConstraint(true);
        return v;
    }

    private void insertSites(Collection vertices) {
        Debug.println("Adding sites: " + vertices.size());
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            ConstraintVertex v = (ConstraintVertex)i.next();
            this.insertSite(v);
        }
    }

    private ConstraintVertex insertSite(ConstraintVertex v) {
        KdNode kdnode = this.kdt.insert(v.getCoordinate(), v);
        if (kdnode.isRepeated()) {
            ConstraintVertex snappedV = (ConstraintVertex)kdnode.getData();
            snappedV.merge(v);
            return snappedV;
        }
        this.incDel.insertSite(v);
        return v;
    }

    public void insertSite(Coordinate p) {
        this.insertSite(this.createVertex(p));
    }

    public void formInitialDelaunay() {
        this.computeBoundingBox();
        this.subdiv = new QuadEdgeSubdivision(this.computeAreaEnv, this.tolerance);
        this.subdiv.setLocator(new LastFoundQuadEdgeLocator(this.subdiv));
        this.incDel = new IncrementalDelaunayTriangulator(this.subdiv);
        this.insertSites(this.initialVertices);
    }

    public void enforceConstraints() {
        this.addConstraintVertices();
        int count = 0;
        int splits = 0;
        do {
            splits = this.enforceGabriel(this.segments);
            Debug.println("Iter: " + ++count + "   Splits: " + splits + "   Current # segments = " + this.segments.size());
        } while (splits > 0 && count < 99);
        if (count == 99) {
            Debug.println("ABORTED! Too many iterations while enforcing constraints");
            if (!Debug.isDebugging()) {
                throw new ConstraintEnforcementException("Too many splitting iterations while enforcing constraints.  Last split point was at: ", this.splitPt);
            }
        }
    }

    private void addConstraintVertices() {
        this.computeConvexHull();
        this.insertSites(this.segVertices);
    }

    private int enforceGabriel(Collection segsToInsert) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        int splits = 0;
        ArrayList<Segment> segsToRemove = new ArrayList<Segment>();
        Iterator i = segsToInsert.iterator();
        while (i.hasNext()) {
            Segment seg = (Segment)i.next();
            Coordinate encroachPt = this.findNonGabrielPoint(seg);
            if (encroachPt == null) continue;
            this.splitPt = this.splitFinder.findSplitPoint(seg, encroachPt);
            ConstraintVertex splitVertex = this.createVertex(this.splitPt, seg);
            ConstraintVertex insertedVertex = this.insertSite(splitVertex);
            if (!insertedVertex.getCoordinate().equals2D(this.splitPt)) {
                Debug.println("Split pt snapped to: " + insertedVertex);
            }
            Segment s1 = new Segment(seg.getStartX(), seg.getStartY(), seg.getStartZ(), splitVertex.getX(), splitVertex.getY(), splitVertex.getZ(), seg.getData());
            Segment s2 = new Segment(splitVertex.getX(), splitVertex.getY(), splitVertex.getZ(), seg.getEndX(), seg.getEndY(), seg.getEndZ(), seg.getData());
            newSegments.add(s1);
            newSegments.add(s2);
            segsToRemove.add(seg);
            ++splits;
        }
        segsToInsert.removeAll(segsToRemove);
        segsToInsert.addAll(newSegments);
        return splits;
    }

    private Coordinate findNonGabrielPoint(Segment seg) {
        Coordinate p = seg.getStart();
        Coordinate q = seg.getEnd();
        Coordinate midPt = new Coordinate((p.x + q.x) / 2.0, (p.y + q.y) / 2.0);
        double segRadius = p.distance(midPt);
        Envelope env = new Envelope(midPt);
        env.expandBy(segRadius);
        List result = this.kdt.query(env);
        Coordinate closestNonGabriel = null;
        double minDist = Double.MAX_VALUE;
        Iterator i = result.iterator();
        while (i.hasNext()) {
            double testRadius;
            KdNode nextNode = (KdNode)i.next();
            Coordinate testPt = nextNode.getCoordinate();
            if (testPt.equals2D(p) || testPt.equals2D(q) || !((testRadius = midPt.distance(testPt)) < segRadius)) continue;
            double testDist = testRadius;
            if (closestNonGabriel != null && !(testDist < minDist)) continue;
            closestNonGabriel = testPt;
            minDist = testDist;
        }
        return closestNonGabriel;
    }
}

