/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.registry.AbstractPropertyFactory;
import rescuecore2.standard.entities.EdgeListProperty;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.properties.BooleanProperty;
import rescuecore2.worldmodel.properties.EntityRefListProperty;
import rescuecore2.worldmodel.properties.EntityRefProperty;
import rescuecore2.worldmodel.properties.IntArrayProperty;
import rescuecore2.worldmodel.properties.IntProperty;

public final class StandardPropertyFactory
extends AbstractPropertyFactory<StandardPropertyURN> {
    public static final StandardPropertyFactory INSTANCE = new StandardPropertyFactory();

    private StandardPropertyFactory() {
        super(StandardPropertyURN.class);
    }

    public Property makeProperty(StandardPropertyURN urn) {
        switch (urn) {
            case START_TIME: 
            case LONGITUDE: 
            case LATITUDE: 
            case WIND_FORCE: 
            case WIND_DIRECTION: 
            case X: 
            case Y: 
            case FLOORS: 
            case BUILDING_ATTRIBUTES: 
            case FIERYNESS: 
            case BROKENNESS: 
            case BUILDING_CODE: 
            case BUILDING_AREA_GROUND: 
            case BUILDING_AREA_TOTAL: 
            case DIRECTION: 
            case STAMINA: 
            case HP: 
            case DAMAGE: 
            case BURIEDNESS: 
            case WATER_QUANTITY: 
            case TEMPERATURE: 
            case IMPORTANCE: 
            case TRAVEL_DISTANCE: 
            case REPAIR_COST: {
                return new IntProperty((Enum)urn);
            }
            case APEXES: 
            case POSITION_HISTORY: {
                return new IntArrayProperty((Enum)urn);
            }
            case IGNITION: {
                return new BooleanProperty((Enum)urn);
            }
            case POSITION: {
                return new EntityRefProperty((Enum)urn);
            }
            case BLOCKADES: {
                return new EntityRefListProperty((Enum)urn);
            }
            case EDGES: {
                return new EdgeListProperty(urn);
            }
        }
        throw new IllegalArgumentException("Unrecognised property urn: " + (Object)((Object)urn));
    }
}

