/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import kernel.KernelState;
import kernel.TerminationCondition;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.worldmodel.Entity;

public class CiviliansDeadOrRescuedTerminationCondition
implements TerminationCondition {
    public void initialise(Config config) {
    }

    public boolean shouldStop(KernelState k) {
        for (Entity next : k.getWorldModel()) {
            if (!(next instanceof Civilian)) continue;
            Civilian c = (Civilian)next;
            if (!(c.isHPDefined() && c.isDamageDefined() && c.isBuriednessDefined() && c.isPositionDefined())) {
                return false;
            }
            if (c.getHP() <= 0) continue;
            if (c.getDamage() > 0 || c.getBuriedness() > 0) {
                return false;
            }
            Entity position = k.getWorldModel().getEntity(c.getPosition());
            if (position instanceof Refuge) continue;
            return false;
        }
        Logger.debug((String)"CiviliansDeadOrRescuedTerminationCondition fired");
        return true;
    }

    public String toString() {
        return "All civilians rescued or dead";
    }
}

