/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import rescuecore2.config.Config;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.misc.AgentPath;
import rescuecore2.standard.view.HumanLayer;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class AnimatedHumanLayer
extends HumanLayer {
    private Set<EntityID> humanIDs = new HashSet<EntityID>();
    private Map<EntityID, Queue<Pair<Integer, Integer>>> frames = new HashMap<EntityID, Queue<Pair<Integer, Integer>>>();
    private boolean animationDone = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise(Config config) {
        super.initialise(config);
        this.humanIDs.clear();
        AnimatedHumanLayer animatedHumanLayer = this;
        synchronized (animatedHumanLayer) {
            this.frames.clear();
            this.animationDone = true;
        }
    }

    @Override
    public String getName() {
        return "Humans (animated)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextFrame() {
        AnimatedHumanLayer animatedHumanLayer = this;
        synchronized (animatedHumanLayer) {
            if (this.animationDone) {
                return false;
            }
            this.animationDone = true;
            for (Queue<Pair<Integer, Integer>> next : this.frames.values()) {
                if (next.size() <= 1) continue;
                next.remove();
                this.animationDone = false;
            }
            return !this.animationDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pair<Integer, Integer> getLocation(Human h) {
        AnimatedHumanLayer animatedHumanLayer = this;
        synchronized (animatedHumanLayer) {
            Queue<Pair<Integer, Integer>> agentFrames = this.frames.get(h.getID());
            if (agentFrames != null && !agentFrames.isEmpty()) {
                return agentFrames.peek();
            }
        }
        return h.getLocation((WorldModel<? extends StandardEntity>)this.world);
    }

    @Override
    protected void preView() {
        super.preView();
        this.humanIDs.clear();
    }

    @Override
    protected void viewObject(Object o) {
        super.viewObject(o);
        if (o instanceof Human) {
            this.humanIDs.add(((Human)((Object)o)).getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeAnimation(int frameCount) {
        AnimatedHumanLayer animatedHumanLayer = this;
        synchronized (animatedHumanLayer) {
            this.frames.clear();
            double step = 1.0 / ((double)frameCount - 1.0);
            for (EntityID next : this.humanIDs) {
                AgentPath path;
                LinkedList<Pair<Integer, Integer>> result = new LinkedList<Pair<Integer, Integer>>();
                Human human = (Human)this.world.getEntity(next);
                if (human == null || (path = AgentPath.computePath(human, this.world)) == null) continue;
                for (int i = 0; i < frameCount; ++i) {
                    Pair<Integer, Integer> nextPoint = path.getPointOnPath((double)i * step);
                    result.add(nextPoint);
                }
                this.frames.put(next, result);
            }
            this.animationDone = false;
        }
    }
}

