/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.ArrayList;
import rescuecore.Handy;
import rescuecore.RescueObject;
import rescuecore.commands.AKAcknowledge;
import rescuecore.commands.AKClear;
import rescuecore.commands.AKConnect;
import rescuecore.commands.AKExtinguish;
import rescuecore.commands.AKLoad;
import rescuecore.commands.AKMove;
import rescuecore.commands.AKRescue;
import rescuecore.commands.AKRest;
import rescuecore.commands.AKSay;
import rescuecore.commands.AKTell;
import rescuecore.commands.AKUnload;
import rescuecore.commands.Command;
import rescuecore.commands.Commands;
import rescuecore.commands.KAConnectError;
import rescuecore.commands.KAConnectOK;
import rescuecore.commands.KAHear;
import rescuecore.commands.KASense;
import rescuecore.commands.KSConnectError;
import rescuecore.commands.KSConnectOK;
import rescuecore.commands.KVConnectError;
import rescuecore.commands.KVConnectOK;
import rescuecore.commands.SKAcknowledge;
import rescuecore.commands.SKConnect;
import rescuecore.commands.SKUpdate;
import rescuecore.commands.Update;
import rescuecore.commands.VKAcknowledge;
import rescuecore.commands.VKConnect;

public class InputBuffer {
    private byte[] data;
    private int index;

    public InputBuffer(byte[] b) {
        this.data = new byte[b.length];
        System.arraycopy(b, 0, this.data, 0, b.length);
    }

    public int getSize() {
        return this.data.length;
    }

    public int available() {
        return this.data.length - this.index;
    }

    public byte readByte() {
        return this.data[this.index++];
    }

    public void readBytes(byte[] result) {
        System.arraycopy(this.data, this.index, result, 0, result.length);
        this.index += result.length;
    }

    public short readShort() {
        int result = this.data[this.index++] << 8 & 0xFF00 | this.data[this.index++] & 0xFF;
        return (short)result;
    }

    public int readInt() {
        int result = this.data[this.index++] << 24 & 0xFF000000 | this.data[this.index++] << 16 & 0xFF0000 | this.data[this.index++] << 8 & 0xFF00 | this.data[this.index++] & 0xFF;
        return result;
    }

    public String readString() {
        byte[] result = new byte[this.readInt()];
        this.readBytes(result);
        return new String(result);
    }

    public void reset() {
        this.index = 0;
    }

    public void skip(int size) {
        this.index += size;
    }

    public int getPosition() {
        return this.index;
    }

    public void setPosition(int i) {
        this.index = i;
    }

    public RescueObject readObject(int timestamp, Object source) {
        int type = this.readInt();
        if (type == 0) {
            return null;
        }
        int id = this.readInt();
        int size = this.readInt();
        RescueObject result = RescueObject.newObject(type);
        if (result == null) {
            this.skip(size);
        } else if (size > 0) {
            result.read(this, timestamp, source);
        }
        result.setID(id);
        return result;
    }

    public RescueObject[] readObjects(int timestamp, Object source) {
        ArrayList<RescueObject> result = new ArrayList<RescueObject>();
        int count = this.readInt();
        for (int i = 0; i < count; ++i) {
            RescueObject next = this.readObject(timestamp, source);
            result.add(next);
        }
        return result.toArray(new RescueObject[0]);
    }

    public Command readCommand() {
        int type = this.readInt();
        if (type == 0) {
            return null;
        }
        int size = this.readInt();
        return this.readCommand(type, size);
    }

    public Command readCommand(int type, int size) {
        Command c = null;
        switch (type) {
            case 134: {
                c = new AKExtinguish(this);
                break;
            }
            case 129: {
                c = new AKMove(this);
                break;
            }
            case 137: {
                c = new AKClear(this);
                break;
            }
            case 130: {
                c = new AKLoad(this);
                break;
            }
            case 131: {
                c = new AKUnload(this);
                break;
            }
            case 136: {
                c = new AKRescue(this);
                break;
            }
            case 132: {
                c = new AKSay(this);
                break;
            }
            case 133: {
                c = new AKTell(this);
                break;
            }
            case 128: {
                c = new AKRest(this);
                break;
            }
            case 64: {
                c = new AKConnect(this);
                break;
            }
            case 65: {
                c = new AKAcknowledge(this);
                break;
            }
            case 66: {
                c = new KAConnectOK(this);
                break;
            }
            case 67: {
                c = new KAConnectError(this);
                break;
            }
            case 68: {
                c = new KASense(this);
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                c = new KAHear(this);
                break;
            }
            case 32: {
                c = new SKConnect(this);
                break;
            }
            case 33: {
                c = new SKAcknowledge(this);
                break;
            }
            case 34: {
                c = new SKUpdate(this);
                break;
            }
            case 35: {
                c = new KSConnectOK(this);
                break;
            }
            case 36: {
                c = new KSConnectError(this);
                break;
            }
            case 81: {
                c = new Commands(this);
                break;
            }
            case 80: {
                c = new Update(this);
                break;
            }
            case 48: {
                c = new VKConnect(this);
                break;
            }
            case 49: {
                c = new VKAcknowledge(this);
                break;
            }
            case 50: {
                c = new KVConnectOK(this);
                break;
            }
            case 51: {
                c = new KVConnectError(this);
                break;
            }
            default: {
                System.err.println("Don't know how to decode commands of type " + Handy.getCommandTypeName(type));
                this.skip(size);
            }
        }
        return c;
    }

    public Command[] readCommands() {
        ArrayList<Command> result = new ArrayList<Command>();
        Command next = null;
        do {
            if ((next = this.readCommand()) == null) continue;
            result.add(next);
        } while (next != null);
        return result.toArray(new Command[0]);
    }
}

