/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.UnsupportedEncodingException;
import rescuecore.RescueObject;
import rescuecore.commands.Command;

public class OutputBuffer {
    private byte[] data;
    private int index;

    public OutputBuffer() {
        this(256);
    }

    public OutputBuffer(int capacity) {
        this.data = new byte[capacity];
    }

    public void writeByte(byte b) {
        this.expand(1);
        this.data[this.index++] = b;
    }

    public void writeBytes(byte[] b) {
        this.expand(b.length * 1);
        for (int i = 0; i < b.length; ++i) {
            this.data[this.index++] = b[i];
        }
    }

    public void writeShort(int s) {
        this.expand(2);
        this.data[this.index++] = (byte)(s >> 8 & 0xFF);
        this.data[this.index++] = (byte)(s & 0xFF);
    }

    public void writeInt(int i) {
        this.expand(4);
        this.data[this.index++] = (byte)(i >> 24 & 0xFF);
        this.data[this.index++] = (byte)(i >> 16 & 0xFF);
        this.data[this.index++] = (byte)(i >> 8 & 0xFF);
        this.data[this.index++] = (byte)(i & 0xFF);
    }

    public void writeString(String s) {
        try {
            byte[] bytes = s.getBytes("UTF-8");
            this.writeInt(bytes.length);
            this.writeBytes(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not found!", e);
        }
    }

    public void writeObject(RescueObject o) {
        this.writeInt(o.getType());
        this.writeInt(o.getID());
        int base = this.markBlock();
        o.write(this);
        this.writeBlockSize(base);
    }

    public void writeObjects(RescueObject[] objects) {
        this.writeInt(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            this.writeObject(objects[i]);
        }
    }

    public void writeCommand(Command c) {
        this.writeInt(c.getType());
        int base = this.markBlock();
        c.write(this);
        this.writeBlockSize(base);
    }

    public void writeCommands(Command[] c) {
        this.writeInt(c.length);
        for (int i = 0; i < c.length; ++i) {
            this.writeCommand(c[i]);
        }
    }

    public int markBlock() {
        this.writeInt(0);
        return this.index;
    }

    public void writeBlockSize(int mark) {
        int size = this.index - mark;
        this.writeInt(size, mark - 4);
    }

    public void clear() {
        this.index = 0;
    }

    public int getSize() {
        return this.index;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.index];
        System.arraycopy(this.data, 0, result, 0, this.index);
        return result;
    }

    public void ensureCapacity(int capacity) {
        this.expand(capacity);
    }

    public void trim(int size) {
        this.index = Math.min(this.index, size);
    }

    private void writeInt(int i, int position) {
        int old = this.index;
        this.index = position;
        this.writeInt(i);
        if (this.index < old) {
            this.index = old;
        }
    }

    private void expand(int needed) {
        if (this.index + needed < this.data.length) {
            return;
        }
        byte[] newData = new byte[Math.max(this.index + needed, this.data.length * 2)];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }
}

