/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import java.io.Serializable;
import rescuecore.Handy;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.AKClear;
import rescuecore.commands.AKExtinguish;
import rescuecore.commands.AKLoad;
import rescuecore.commands.AKMove;
import rescuecore.commands.AKRescue;
import rescuecore.commands.AKSay;
import rescuecore.commands.AKTell;
import rescuecore.commands.AKUnload;

public abstract class Command
implements Serializable {
    protected int type;

    protected Command(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public abstract void write(OutputBuffer var1);

    public abstract void read(InputBuffer var1);

    public String toString() {
        return Handy.getCommandTypeName(this.type);
    }

    public static Command EXTINGUISH(int agentID, int time, int targetID) {
        return Command.EXTINGUISH(agentID, time, targetID, 0, 0, 0, 1000);
    }

    public static Command EXTINGUISH(int agentID, int time, int targetID, int direction, int x, int y) {
        return Command.EXTINGUISH(agentID, time, targetID, direction, x, y, 1000);
    }

    public static Command EXTINGUISH(int agentID, int time, int targetID, int direction, int x, int y, int water) {
        return new AKExtinguish(agentID, time, targetID, direction, x, y, water);
    }

    public static Command CLEAR(int id, int time, int target) {
        return new AKClear(id, time, target);
    }

    public static Command RESCUE(int id, int time, int target) {
        return new AKRescue(id, time, target);
    }

    public static Command LOAD(int id, int time, int target) {
        return new AKLoad(id, time, target);
    }

    public static Command UNLOAD(int id, int time) {
        return new AKUnload(id, time);
    }

    public static Command MOVE(int id, int time, int[] path) {
        return new AKMove(id, time, path);
    }

    public static Command SAY(int id, int time, byte[] msg, int length) {
        return new AKSay(id, time, msg, length);
    }

    public static Command TELL(int id, int time, byte[] msg, int length, byte channel) {
        return new AKTell(id, time, msg, length, channel);
    }
}

