/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import java.util.ArrayList;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.AgentCommand;
import rescuecore.commands.Command;

public class Commands
extends Command {
    private int time;
    private AgentCommand[] commands;

    public Commands(int time, AgentCommand[] commands) {
        super(81);
        this.time = time;
        this.commands = commands;
    }

    public Commands(InputBuffer in) {
        super(81);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        this.time = in.readInt();
        Command[] all = in.readCommands();
        ArrayList<Command> allCommands = new ArrayList<Command>();
        for (Command next : all) {
            if (!(next instanceof AgentCommand)) continue;
            allCommands.add(next);
        }
        this.commands = new AgentCommand[allCommands.size()];
        allCommands.toArray(this.commands);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.time);
        out.writeCommands(this.commands);
    }

    public int getTime() {
        return this.time;
    }

    public AgentCommand[] getCommands() {
        return this.commands;
    }
}

