/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rescuecore.Memory;
import rescuecore.debug.Handler;
import rescuecore.view.Layer;

public class CollectionHandler
implements Handler {
    private Collection current;
    private Layer layer;
    private CollectionView component;

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new CollectionView();
            this.component.setObjects(this.current);
        }
        return this.component;
    }

    @Override
    public Layer getLayer() {
        if (this.layer == null) {
            this.layer = new Layer("Collection handler");
            this.layer.addObjects(this.current);
        }
        return this.layer;
    }

    @Override
    public boolean handle(Object o, int timeStep) {
        if (o instanceof Collection) {
            this.current = (Collection)o;
            if (this.layer != null) {
                this.layer.setObjects(this.current);
            }
            if (this.component != null) {
                this.component.setObjects(this.current);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setMemory(Memory m) {
    }

    private static class CollectionView
    extends JPanel {
        private CollectionModel model = new CollectionModel();

        public CollectionView() {
            super(new BorderLayout());
            this.add((Component)new JScrollPane(new JList(this.model)), "Center");
        }

        public void setObjects(Collection c) {
            this.model.setObjects(c);
        }

        private static class CollectionModel
        extends AbstractListModel {
            private String[] data = new String[0];

            @Override
            public int getSize() {
                return this.data.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.data[index];
            }

            public void setObjects(Collection c) {
                this.data = new String[c.size()];
                int i = 0;
                for (Object next : c) {
                    this.data[i] = next == null ? "null" : next.toString();
                    ++i;
                }
                this.fireContentsChanged(this, 0, this.data.length);
            }
        }
    }
}

