/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.commands.KASense;
import rescuecore.commands.Update;
import rescuecore.debug.Handler;
import rescuecore.view.Layer;

public class UpdateHandler
implements Handler {
    private DefaultListModel messages;
    private JScrollPane messagePane;

    public UpdateHandler() {
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createTitledBorder("Updates"));
        this.messages = new DefaultListModel();
        JList messageList = new JList(this.messages);
        messagePanel.add(messageList, "Center");
        this.messagePane = new JScrollPane(messagePanel);
        this.messagePane.setPreferredSize(new Dimension(200, 80));
    }

    @Override
    public void setMemory(Memory m) {
    }

    @Override
    public JComponent getComponent() {
        return this.messagePane;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public boolean handle(Object o, int timeStep) {
        RescueObject[] objects;
        int time;
        if (o instanceof KASense) {
            time = ((KASense)o).getTime();
            objects = ((KASense)o).getUpdatedObjects();
        } else if (o instanceof Update) {
            time = ((Update)o).getTime();
            objects = ((Update)o).getUpdatedObjects();
        } else {
            return false;
        }
        this.messages.clear();
        for (RescueObject next : objects) {
            int[] known;
            this.messages.addElement(next.toString());
            for (int prop : known = next.getKnownPropertyTypes()) {
                if (next.getLastPropertyUpdate(prop) != time) continue;
                this.messages.addElement("  " + next.getProperty(prop));
            }
        }
        return true;
    }
}

