/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.Edge;

public class Road
extends Edge {
    private IntProperty kind;
    private IntProperty carsToHead;
    private IntProperty carsToTail;
    private IntProperty humansToHead;
    private IntProperty humansToTail;
    private IntProperty width;
    private IntProperty block;
    private IntProperty cost;
    private IntProperty median;
    private IntProperty linesToHead;
    private IntProperty linesToTail;
    private IntProperty widthForWalkers;

    public Road() {
        this.kind = new IntProperty(9);
        this.carsToHead = new IntProperty(10);
        this.carsToTail = new IntProperty(11);
        this.humansToHead = new IntProperty(12);
        this.humansToTail = new IntProperty(13);
        this.width = new IntProperty(14);
        this.block = new IntProperty(15);
        this.cost = new IntProperty(16);
        this.median = new IntProperty(17);
        this.linesToHead = new IntProperty(18);
        this.linesToTail = new IntProperty(19);
        this.widthForWalkers = new IntProperty(20);
    }

    public Road(int head, int tail, int length, int kind, int cth, int ctt, int hth, int htt, int width, int block, int cost, boolean median, int lth, int ltt, int wfw) {
        super(head, tail, length);
        this.kind = new IntProperty(9, kind);
        this.carsToHead = new IntProperty(10, cth);
        this.carsToTail = new IntProperty(11, ctt);
        this.humansToHead = new IntProperty(12, hth);
        this.humansToTail = new IntProperty(13, htt);
        this.width = new IntProperty(14, width);
        this.block = new IntProperty(15, block);
        this.cost = new IntProperty(16, cost);
        this.median = new IntProperty(17, median);
        this.linesToHead = new IntProperty(18, lth);
        this.linesToTail = new IntProperty(19, ltt);
        this.widthForWalkers = new IntProperty(20, wfw);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 9: {
                return this.kind;
            }
            case 10: {
                return this.carsToHead;
            }
            case 11: {
                return this.carsToTail;
            }
            case 12: {
                return this.humansToHead;
            }
            case 13: {
                return this.humansToTail;
            }
            case 14: {
                return this.width;
            }
            case 15: {
                return this.block;
            }
            case 16: {
                return this.cost;
            }
            case 17: {
                return this.median;
            }
            case 18: {
                return this.linesToHead;
            }
            case 19: {
                return this.linesToTail;
            }
            case 20: {
                return this.widthForWalkers;
            }
        }
        return super.getProperty(property);
    }

    public int getRoadKind() {
        return this.kind.getValue();
    }

    public boolean setRoadKind(int k, int timestamp, Object source) {
        if (this.kind.updateValue(k, timestamp, source)) {
            this.firePropertyChanged(9, timestamp, source);
            return true;
        }
        return false;
    }

    public int getCarsPassToHead() {
        return this.carsToHead.getValue();
    }

    public boolean setCarsPassToHead(int cars, int timestamp, Object source) {
        if (this.carsToHead.updateValue(cars, timestamp, source)) {
            this.firePropertyChanged(10, timestamp, source);
            return true;
        }
        return false;
    }

    public int getCarsPassToTail() {
        return this.carsToTail.getValue();
    }

    public boolean setCarsPassToTail(int cars, int timestamp, Object source) {
        if (this.carsToTail.updateValue(cars, timestamp, source)) {
            this.firePropertyChanged(11, timestamp, source);
            return true;
        }
        return false;
    }

    public int getHumansPassToHead() {
        return this.humansToHead.getValue();
    }

    public boolean setHumansPassToHead(int h, int timestamp, Object source) {
        if (this.humansToHead.updateValue(h, timestamp, source)) {
            this.firePropertyChanged(12, timestamp, source);
            return true;
        }
        return false;
    }

    public int getHumansPassToTail() {
        return this.humansToTail.getValue();
    }

    public boolean setHumansPassToTail(int h, int timestamp, Object source) {
        if (this.humansToTail.updateValue(h, timestamp, source)) {
            this.firePropertyChanged(13, timestamp, source);
            return true;
        }
        return false;
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public boolean setWidth(int w, int timestamp, Object source) {
        if (this.width.updateValue(w, timestamp, source)) {
            this.firePropertyChanged(14, timestamp, source);
            return true;
        }
        return false;
    }

    public int getBlock() {
        return this.block.getValue();
    }

    public boolean setBlock(int b, int timestamp, Object source) {
        if (this.block.updateValue(b, timestamp, source)) {
            this.firePropertyChanged(15, timestamp, source);
            return true;
        }
        return false;
    }

    public int getRepairCost() {
        return this.cost.getValue();
    }

    public boolean setRepairCost(int c, int timestamp, Object source) {
        if (this.cost.updateValue(c, timestamp, source)) {
            this.firePropertyChanged(16, timestamp, source);
            return true;
        }
        return false;
    }

    public boolean hasMedian() {
        return this.median.getValue() != 0;
    }

    public boolean setMedian(boolean b, int timestamp, Object source) {
        if (this.median.updateValue(b ? 1 : 0, timestamp, source)) {
            this.firePropertyChanged(17, timestamp, source);
            return true;
        }
        return false;
    }

    public int getLinesToHead() {
        return this.linesToHead.getValue();
    }

    public boolean setLinesToHead(int l, int timestamp, Object source) {
        if (this.linesToHead.updateValue(l, timestamp, source)) {
            this.firePropertyChanged(18, timestamp, source);
            return true;
        }
        return false;
    }

    public int getLinesToTail() {
        return this.linesToTail.getValue();
    }

    public boolean setLinesToTail(int l, int timestamp, Object source) {
        if (this.linesToTail.updateValue(l, timestamp, source)) {
            this.firePropertyChanged(19, timestamp, source);
            return true;
        }
        return false;
    }

    public int getWidthForWalkers() {
        return this.widthForWalkers.getValue();
    }

    public boolean setWidthForWalkers(int w, int timestamp, Object source) {
        if (this.widthForWalkers.updateValue(w, timestamp, source)) {
            this.firePropertyChanged(20, timestamp, source);
            return true;
        }
        return false;
    }

    public boolean isBlocked() {
        return this.getBlock() > 0;
    }

    public boolean hasBlockedLines() {
        return this.getBlockedLines() > 0;
    }

    public boolean hasFreeLines() {
        return this.getFreeLinesToHead() > 0 && this.getFreeLinesToTail() > 0;
    }

    public int getFreeLinesToHead() {
        double lanes = this.getLinesToHead() + this.getLinesToTail();
        double laneWidth = (double)this.getWidth() / lanes;
        int blockedLanes = (int)Math.floor((double)this.getBlock() / laneWidth / 2.0 + 0.5);
        return this.getLinesToHead() - blockedLanes;
    }

    public int getFreeLinesToTail() {
        double lanes = this.getLinesToHead() + this.getLinesToTail();
        double laneWidth = (double)this.getWidth() / lanes;
        int blockedLanes = (int)Math.floor((double)this.getBlock() / laneWidth / 2.0 + 0.5);
        return this.getLinesToTail() - blockedLanes;
    }

    public int getBlockedLines() {
        double lanes = this.getLinesToHead() + this.getLinesToTail();
        double laneWidth = (double)this.getWidth() / lanes;
        int blockedLanes = (int)Math.floor((double)this.getBlock() / laneWidth / 2.0 + 0.5);
        return blockedLanes * 2;
    }
}

