/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.objects.AmbulanceCenter;
import rescuecore.objects.AmbulanceTeam;
import rescuecore.objects.Building;
import rescuecore.objects.Civilian;
import rescuecore.objects.FireBrigade;
import rescuecore.objects.FireStation;
import rescuecore.objects.Node;
import rescuecore.objects.PoliceForce;
import rescuecore.objects.PoliceOffice;
import rescuecore.objects.Refuge;
import rescuecore.objects.Road;

public class MapFiles {
    private static final int GIS_TYPE_AMBULANCE_CENTER = 2;
    private static final int GIS_TYPE_FIRE_STATION = 3;
    private static final int GIS_TYPE_POLICE_OFFICE = 4;
    private static final int GIS_TYPE_REFUGE = 5;
    private static final int GIS_TYPE_CIVILIAN = 6;
    private static final int GIS_TYPE_AMBULANCE_TEAM = 7;
    private static final int GIS_TYPE_FIRE_BRIGADE = 8;
    private static final int GIS_TYPE_POLICE_FORCE = 9;
    private static final int GIS_TYPE_FIRE = 10;
    private static final String[] GIS_TYPES = new String[]{"", "", "AmbulanceCenter", "FireStation", "PoliceOffice", "Refuge", "Civilian", "AmbulanceTeam", "FireBrigade", "PoliceForce", "FirePoint"};

    private static int readInt(InputStream in) throws IOException {
        int result = in.read() & 0xFF | in.read() << 8 & 0xFF00 | in.read() << 16 & 0xFF0000 | in.read() << 24 & 0xFF000000;
        return result;
    }

    private static void writeInt(OutputStream out, int value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value >> 16 & 0xFF);
        out.write(value >> 24 & 0xFF);
    }

    public static Node[] loadNodes() throws IOException {
        return MapFiles.loadNodes("node.bin");
    }

    public static Node[] loadNodes(File parentDir) throws IOException {
        return MapFiles.loadNodes(parentDir.getAbsolutePath() + File.separator + "node.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] loadNodes(String file) throws IOException {
        System.out.print("Loading nodes from " + file);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            int num = MapFiles.readInt(in);
            Node[] result = new Node[num];
            for (int i = 0; i < num; ++i) {
                int j;
                int size = MapFiles.readInt(in);
                int id = MapFiles.readInt(in);
                int x = MapFiles.readInt(in);
                int y = MapFiles.readInt(in);
                int numEdges = MapFiles.readInt(in);
                int[] edges = new int[numEdges];
                int[] shortcut = new int[numEdges];
                int[] pocket = new int[numEdges * 2];
                int[] signalTiming = new int[numEdges * 3];
                for (int j2 = 0; j2 < numEdges; ++j2) {
                    edges[j2] = MapFiles.readInt(in);
                }
                int signal = MapFiles.readInt(in);
                for (j = 0; j < numEdges; ++j) {
                    shortcut[j] = MapFiles.readInt(in);
                }
                for (j = 0; j < numEdges; ++j) {
                    pocket[j * 2] = MapFiles.readInt(in);
                    pocket[j * 2 + 1] = MapFiles.readInt(in);
                }
                for (j = 0; j < numEdges; ++j) {
                    signalTiming[j * 3] = MapFiles.readInt(in);
                    signalTiming[j * 3 + 1] = MapFiles.readInt(in);
                    signalTiming[j * 3 + 2] = MapFiles.readInt(in);
                }
                result[i] = new Node(x, y, edges, signal != 0, shortcut, pocket, signalTiming);
                result[i].setID(id);
                System.out.print(".");
            }
            System.out.println();
            Node[] nodeArray = result;
            return nodeArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static Road[] loadRoads() throws IOException {
        return MapFiles.loadRoads("road.bin");
    }

    public static Road[] loadRoads(File parentDir) throws IOException {
        return MapFiles.loadRoads(parentDir.getAbsolutePath() + File.separator + "road.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Road[] loadRoads(String file) throws IOException {
        System.out.print("Loading roads from " + file);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            int num = MapFiles.readInt(in);
            Road[] result = new Road[num];
            for (int i = 0; i < num; ++i) {
                int size = MapFiles.readInt(in);
                int id = MapFiles.readInt(in);
                int head = MapFiles.readInt(in);
                int tail = MapFiles.readInt(in);
                int length = MapFiles.readInt(in);
                int roadKind = MapFiles.readInt(in);
                int carsToHead = MapFiles.readInt(in);
                int carsToTail = MapFiles.readInt(in);
                int humansToHead = MapFiles.readInt(in);
                int humansToTail = MapFiles.readInt(in);
                int width = MapFiles.readInt(in);
                int block = MapFiles.readInt(in);
                int repairCost = MapFiles.readInt(in);
                int median = MapFiles.readInt(in);
                int linesToHead = MapFiles.readInt(in);
                int linesToTail = MapFiles.readInt(in);
                int widthForWalkers = MapFiles.readInt(in);
                result[i] = new Road(head, tail, length, roadKind, carsToHead, carsToTail, humansToHead, humansToTail, width, block, repairCost, median != 0, linesToHead, linesToTail, widthForWalkers);
                result[i].setID(id);
                System.out.print(".");
            }
            System.out.println();
            Road[] roadArray = result;
            return roadArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static Building[] loadBuildings() throws IOException {
        return MapFiles.loadBuildings("building.bin");
    }

    public static Building[] loadBuildings(File parentDir) throws IOException {
        return MapFiles.loadBuildings(parentDir.getAbsolutePath() + File.separator + "building.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Building[] loadBuildings(String file) throws IOException {
        System.out.print("Loading buildings from " + file);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            MapFiles.readInt(in);
            int num = MapFiles.readInt(in);
            Building[] result = new Building[num];
            for (int i = 0; i < num; ++i) {
                int size = MapFiles.readInt(in);
                int id = MapFiles.readInt(in);
                int x = MapFiles.readInt(in);
                int y = MapFiles.readInt(in);
                int floors = MapFiles.readInt(in);
                int attributes = MapFiles.readInt(in);
                int ignition = MapFiles.readInt(in);
                int fieryness = MapFiles.readInt(in);
                int brokenness = MapFiles.readInt(in);
                int numEntrances = MapFiles.readInt(in);
                int[] entrances = new int[numEntrances];
                for (int j = 0; j < numEntrances; ++j) {
                    entrances[j] = MapFiles.readInt(in);
                }
                int shapeID = MapFiles.readInt(in);
                int area = MapFiles.readInt(in);
                int totalArea = MapFiles.readInt(in);
                int code = MapFiles.readInt(in);
                int numApexes = MapFiles.readInt(in);
                int[] apexes = new int[numApexes * 2];
                for (int j = 0; j < numApexes; ++j) {
                    apexes[j * 2] = MapFiles.readInt(in);
                    apexes[j * 2 + 1] = MapFiles.readInt(in);
                }
                result[i] = new Building(x, y, floors, attributes, ignition != 0, fieryness, brokenness, entrances, code, area, totalArea, apexes, 0, 1);
                result[i].setID(id);
                System.out.print(".");
            }
            System.out.println();
            Building[] buildingArray = result;
            return buildingArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBuildings(String file, Building[] bs) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            MapFiles.writeInt(out, 0);
            MapFiles.writeInt(out, 0);
            MapFiles.writeInt(out, 0);
            MapFiles.writeInt(out, bs.length);
            for (int i = 0; i < bs.length; ++i) {
                MapFiles.writeInt(out, MapFiles.getSize(bs[i]));
                MapFiles.writeInt(out, bs[i].getID());
                MapFiles.writeInt(out, bs[i].getX());
                MapFiles.writeInt(out, bs[i].getY());
                MapFiles.writeInt(out, bs[i].getFloors());
                MapFiles.writeInt(out, bs[i].getBuildingAttributes());
                MapFiles.writeInt(out, bs[i].isIgnited() ? 1 : 0);
                MapFiles.writeInt(out, bs[i].getFieryness());
                MapFiles.writeInt(out, bs[i].getBrokenness());
                int[] ent = bs[i].getEntrances();
                MapFiles.writeInt(out, ent.length);
                for (int j = 0; j < ent.length; ++j) {
                    MapFiles.writeInt(out, ent[j]);
                }
                MapFiles.writeInt(out, 0);
                MapFiles.writeInt(out, bs[i].getGroundArea());
                MapFiles.writeInt(out, bs[i].getTotalArea());
                MapFiles.writeInt(out, bs[i].getBuildingCode());
                int[] ap = bs[i].getApexes();
                MapFiles.writeInt(out, ap.length / 2);
                for (int j = 0; j < ap.length; ++j) {
                    MapFiles.writeInt(out, ap[j]);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNodes(String file, Node[] ns) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            MapFiles.writeInt(out, 5);
            MapFiles.writeInt(out, -152950000);
            MapFiles.writeInt(out, 52050000);
            MapFiles.writeInt(out, ns.length);
            for (int i = 0; i < ns.length; ++i) {
                MapFiles.writeInt(out, MapFiles.getSize(ns[i]));
                MapFiles.writeInt(out, ns[i].getID());
                MapFiles.writeInt(out, ns[i].getX());
                MapFiles.writeInt(out, ns[i].getY());
                int[] ed = ns[i].getEdges();
                MapFiles.writeInt(out, ed.length);
                for (int j = 0; j < ed.length; ++j) {
                    MapFiles.writeInt(out, ed[j]);
                }
                MapFiles.writeInt(out, ns[i].hasSignal() ? 1 : 0);
                int[] sh = ns[i].getShortcutToTurn();
                for (int j = 0; j < sh.length; ++j) {
                    MapFiles.writeInt(out, sh[j]);
                }
                int[] p = ns[i].getPocketToTurnAcross();
                for (int j = 0; j < p.length; ++j) {
                    MapFiles.writeInt(out, p[j]);
                }
                int[] st = ns[i].getSignalTiming();
                for (int j = 0; j < st.length; ++j) {
                    MapFiles.writeInt(out, st[j]);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRoads(String file, Road[] roads) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            MapFiles.writeInt(out, 5);
            MapFiles.writeInt(out, -152950000);
            MapFiles.writeInt(out, 52050000);
            MapFiles.writeInt(out, roads.length);
            for (int i = 0; i < roads.length; ++i) {
                MapFiles.writeInt(out, MapFiles.getSize(roads[i]));
                MapFiles.writeInt(out, roads[i].getID());
                MapFiles.writeInt(out, roads[i].getHead());
                MapFiles.writeInt(out, roads[i].getTail());
                MapFiles.writeInt(out, roads[i].getLength());
                MapFiles.writeInt(out, roads[i].getRoadKind());
                MapFiles.writeInt(out, roads[i].getCarsPassToHead());
                MapFiles.writeInt(out, roads[i].getCarsPassToTail());
                MapFiles.writeInt(out, roads[i].getHumansPassToHead());
                MapFiles.writeInt(out, roads[i].getHumansPassToTail());
                MapFiles.writeInt(out, roads[i].getWidth());
                MapFiles.writeInt(out, roads[i].getBlock());
                MapFiles.writeInt(out, roads[i].getRepairCost());
                MapFiles.writeInt(out, roads[i].hasMedian() ? 1 : 0);
                MapFiles.writeInt(out, roads[i].getLinesToHead());
                MapFiles.writeInt(out, roads[i].getLinesToTail());
                MapFiles.writeInt(out, roads[i].getWidthForWalkers());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void writeGISMotionlessObjects(PrintWriter out, FireStation[] fire, PoliceOffice[] police, AmbulanceCenter[] ambulance, Refuge[] refuge) {
        int i;
        out.println("# Motionless Objects");
        for (i = 0; i < fire.length; ++i) {
            MapFiles.writeFixedObjectData(out, 3, fire[i]);
        }
        for (i = 0; i < police.length; ++i) {
            MapFiles.writeFixedObjectData(out, 4, police[i]);
        }
        for (i = 0; i < ambulance.length; ++i) {
            MapFiles.writeFixedObjectData(out, 2, ambulance[i]);
        }
        for (i = 0; i < refuge.length; ++i) {
            MapFiles.writeFixedObjectData(out, 5, refuge[i]);
        }
    }

    public static void writeGISMovingObjects(PrintWriter out, FireBrigade[] fire, PoliceForce[] police, AmbulanceTeam[] ambulance, Civilian[] civ, Memory m) {
        int i;
        out.println("# Moving Objects");
        for (i = 0; i < civ.length; ++i) {
            MapFiles.writeMovingObjectData(out, 6, m.lookup(civ[i].getPosition()), m);
        }
        for (i = 0; i < ambulance.length; ++i) {
            MapFiles.writeMovingObjectData(out, 7, m.lookup(ambulance[i].getPosition()), m);
        }
        for (i = 0; i < fire.length; ++i) {
            MapFiles.writeMovingObjectData(out, 8, m.lookup(fire[i].getPosition()), m);
        }
        for (i = 0; i < police.length; ++i) {
            MapFiles.writeMovingObjectData(out, 9, m.lookup(police[i].getPosition()), m);
        }
    }

    public static void writeGISFires(PrintWriter out, Building[] fires) {
        out.println("# Fires");
        for (int i = 0; i < fires.length; ++i) {
            MapFiles.writeFixedObjectData(out, 10, fires[i]);
        }
    }

    public static void writeGISImportantBuildings(PrintWriter out, Building[] buildings) {
        out.println("# Important buildings");
        for (int i = 0; i < buildings.length; ++i) {
            if (buildings[i].getImportance() <= 1) continue;
            out.print("ImportantBuilding ");
            out.print(buildings[i].getID());
            out.print("=");
            out.println(buildings[i].getImportance());
        }
    }

    private static void writeFixedObjectData(PrintWriter out, int type, Building b) {
        out.print(GIS_TYPES[type]);
        out.print("=");
        out.print(b.getID());
        out.println();
    }

    private static void writeMovingObjectData(PrintWriter out, int type, RescueObject location, Memory m) {
        out.print(GIS_TYPES[type]);
        out.print("=");
        out.print(location.getID());
        if (location.isRoad()) {
            Road r = (Road)location;
            Node head = m.getHead(r);
            Node tail = m.getTail(r);
            int extra = (int)(Math.random() * (double)r.getLength() / 1000.0);
            out.print(",");
            out.print(extra);
        }
        out.println();
    }

    private static int getSize(Building b) {
        return (15 + b.getEntrances().length + b.getApexes().length) * 4;
    }

    private static int getSize(Node n) {
        return (6 + n.getEdges().length * 7) * 4;
    }

    private static int getSize(Road r) {
        return 64;
    }
}

