/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import rescuecore.objects.Building;
import rescuecore.objects.Node;
import rescuecore.tools.MapFiles;

public class RandomPolydata {
    private static final int DEFAULT_CENTERS = 4;
    private static final int DEFAULT_MAX_LEVEL = 4;
    private static final int DEFAULT_MIN_LEVEL = 1;
    private static final int DEFAULT_REPEAT = 1;
    private static final int DEFAULT_MAX_SIZE = 50;
    private static final int DEFAULT_MIN_SIZE = 10;

    private static void printUsage() {
        System.out.println("Usage: RandomPolydata [options]");
        System.out.println("Options");
        System.out.println("=======");
        System.out.println("-n\t--num-centers\tThe number of epicenters");
        System.out.println("-l\t--max-level\tThe maximum magnitude level");
        System.out.println("-e\t--min-level\tThe minimum magnitude level");
        System.out.println("-r\t--repeat-levels\tThe number of times to repeat levels");
        System.out.println("-x\t--max-size\tThe maximum size of the polygons produced by each center as a proportion of the map size (100 means 100% of the map can be covered)");
        System.out.println("-m\t--min-size\tThe minimum size of the polygons produced by each center as a proportion of the map size");
        System.out.println("--box=left,right,top,bottom,magnitude");
    }

    public static void main(String[] args) {
        Polygon[] gal;
        Polygon[] shindo;
        int i;
        Building[] allBuildings;
        Node[] allNodes;
        int numCenters = 4;
        int maxLevel = 4;
        int minLevel = 1;
        int repeat = 1;
        int maxSize = 50;
        int minSize = 10;
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equalsIgnoreCase("-h") || args[i2].equalsIgnoreCase("--help")) {
                RandomPolydata.printUsage();
                return;
            }
            if (args[i2].equalsIgnoreCase("-n") || args[i2].equalsIgnoreCase("--num-centers")) {
                numCenters = Integer.parseInt(args[++i2]);
                continue;
            }
            if (args[i2].equalsIgnoreCase("-l") || args[i2].equalsIgnoreCase("--max-level")) {
                maxLevel = Integer.parseInt(args[++i2]);
                continue;
            }
            if (args[i2].equalsIgnoreCase("-e") || args[i2].equalsIgnoreCase("--min-level")) {
                minLevel = Integer.parseInt(args[++i2]);
                continue;
            }
            if (args[i2].equalsIgnoreCase("-r") || args[i2].equalsIgnoreCase("--repeat-levels")) {
                repeat = Integer.parseInt(args[++i2]);
                continue;
            }
            if (args[i2].equalsIgnoreCase("-x") || args[i2].equalsIgnoreCase("--max-size")) {
                maxSize = Integer.parseInt(args[++i2]);
                continue;
            }
            if (args[i2].equalsIgnoreCase("-m") || args[i2].equalsIgnoreCase("--min-size")) {
                minSize = Integer.parseInt(args[++i2]);
                continue;
            }
            if (!args[i2].startsWith("--box")) continue;
            StringTokenizer tokens = new StringTokenizer(args[i2].substring(6), ",");
            double left = Double.parseDouble(tokens.nextToken());
            double right = Double.parseDouble(tokens.nextToken());
            double top = Double.parseDouble(tokens.nextToken());
            double bottom = Double.parseDouble(tokens.nextToken());
            int magnitude = Integer.parseInt(tokens.nextToken());
            boxes.add(new Box(left, right, top, bottom, magnitude));
        }
        try {
            allNodes = MapFiles.loadNodes();
            allBuildings = MapFiles.loadBuildings();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int minX = allNodes[0].getX();
        int minY = allNodes[0].getY();
        int maxX = minX;
        int maxY = minY;
        for (i = 0; i < allNodes.length; ++i) {
            minX = Math.min(minX, allNodes[i].getX());
            maxX = Math.max(maxX, allNodes[i].getX());
            minY = Math.min(minY, allNodes[i].getY());
            maxY = Math.max(maxY, allNodes[i].getY());
        }
        for (i = 0; i < allBuildings.length; ++i) {
            minX = Math.min(minX, allBuildings[i].getX());
            maxX = Math.max(maxX, allBuildings[i].getX());
            minY = Math.min(minY, allBuildings[i].getY());
            maxY = Math.max(maxY, allBuildings[i].getY());
        }
        int xRange = maxX - minX;
        int yRange = maxY - minY;
        if (boxes.size() == 0) {
            ArrayList<Polygon> shindoPolygons = new ArrayList<Polygon>();
            ArrayList<Polygon> galPolygons = new ArrayList<Polygon>();
            int levelRange = maxLevel - minLevel;
            for (int i3 = 0; i3 < numCenters; ++i3) {
                int centerX = (int)(Math.random() * (double)xRange) + minX;
                int centerY = (int)(Math.random() * (double)yRange) + minY;
                int level = (int)(Math.random() * (double)levelRange) + minLevel;
                int repeats = (int)(Math.random() * (double)repeat) + repeat;
                double xSize = Math.random() * (double)(maxSize - minSize) + (double)minSize;
                int xExtent = (int)((double)xRange * xSize / 100.0);
                double ySize = Math.random() * (double)(maxSize - minSize) + (double)minSize;
                int yExtent = (int)((double)yRange * ySize / 100.0);
                System.out.println("Placing level " + level + " epicenter at " + centerX + "," + centerY + " with " + repeats + " repeats. Size is " + xExtent + " x " + yExtent);
                int[] xs = new int[8];
                int[] ys = new int[8];
                xs[0] = xs[4] = centerX;
                xs[1] = xs[3] = centerX + xExtent / 2;
                xs[2] = centerX + xExtent;
                xs[5] = xs[7] = centerX - xExtent / 2;
                xs[6] = centerX - xExtent;
                ys[0] = centerY + yExtent;
                ys[1] = ys[7] = centerY + yExtent / 2;
                ys[2] = ys[6] = centerY;
                ys[3] = ys[5] = centerY - yExtent / 2;
                ys[4] = centerY - yExtent;
                for (int j = 0; j < repeat; ++j) {
                    shindoPolygons.add(new Polygon(level, xs, ys, 8));
                    galPolygons.add(new Polygon(level, xs, ys, 8));
                }
            }
            shindo = new Polygon[shindoPolygons.size()];
            gal = new Polygon[galPolygons.size()];
            shindoPolygons.toArray(shindo);
            galPolygons.toArray(gal);
        } else {
            shindo = new Polygon[boxes.size()];
            gal = new Polygon[boxes.size()];
            int i4 = 0;
            System.out.println("World extends from " + minX + "," + minY + " to " + maxX + "," + maxY);
            for (Box next : boxes) {
                int[] xs = new int[4];
                int[] ys = new int[4];
                int left = (int)((double)xRange * next.left + (double)minX);
                int right = (int)((double)xRange * next.right + (double)minX);
                int top = (int)((double)yRange * next.top + (double)minY);
                int bottom = (int)((double)yRange * next.bottom + (double)minY);
                xs[0] = xs[3] = left;
                xs[1] = xs[2] = right;
                ys[0] = ys[1] = top;
                ys[2] = ys[3] = bottom;
                shindo[i4] = new Polygon(next.size, xs, ys, 4);
                gal[i4] = new Polygon(next.size, xs, ys, 4);
                System.out.println("Putting box from " + left + "," + top + " to " + right + "," + bottom);
                ++i4;
            }
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("shindopolydata.dat")));
            RandomPolydata.writePolydata(shindo, out);
            out.flush();
            out.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter("galpolydata.dat")));
            RandomPolydata.writePolydata(gal, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writePolydata(Polygon[] polygons, PrintWriter out) throws IOException {
        int i;
        int sum = 0;
        for (i = 0; i < polygons.length; ++i) {
            sum += polygons[i].numPoints * 2;
            sum += 2;
        }
        out.print(sum);
        out.print(",");
        out.println(polygons.length);
        for (i = 0; i < polygons.length; ++i) {
            out.print(polygons[i].level);
            out.print(",");
            out.println(polygons[i].numPoints);
            for (int j = 0; j < polygons[i].numPoints; ++j) {
                out.print(polygons[i].xs[j]);
                out.print(",");
                out.println(polygons[i].ys[j]);
            }
        }
    }

    private static class Box {
        double left;
        double right;
        double top;
        double bottom;
        int size;

        public Box(double l, double r, double t, double b, int s) {
            this.left = l;
            this.right = r;
            this.top = t;
            this.bottom = b;
            this.size = s;
        }
    }

    private static class Polygon {
        int level;
        int[] xs;
        int[] ys;
        int numPoints;

        Polygon(int l, int[] x, int[] y, int num) {
            this.level = l;
            this.xs = x;
            this.ys = y;
            this.numPoints = num;
        }
    }
}

