/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.util.Random;
import rescuecore.tools.mapgenerator.RescueMap;

public class RoadSetFactory {
    private static final int MIN_START_DISTANCE = 30000;
    private static final int MAX_START_DISTANCE = 80000;

    public static RescueMap createRoadSet(String scheme, int width, int height, int density, Random rand) {
        if (scheme.equals("  ")) {
            return null;
        }
        return RoadSetFactory.grid(width, height, density);
    }

    private static RescueMap grid(int width, int height, int density) {
        int spacing = (100 - density) * 50000 / 100 + 30000;
        int xCount = width / spacing;
        int yCount = height / spacing;
        System.out.println("Creating a " + xCount + "x" + yCount + " grid = " + xCount * yCount + " intersections.");
        RescueMap rm = new RescueMap(xCount * yCount, width, height);
        for (int i = 0; i < yCount; ++i) {
            for (int j = 0; j < xCount; ++j) {
                int index = i * xCount + j;
                rm.setX(index, j * spacing);
                rm.setY(index, i * spacing);
                if (i > 0) {
                    rm.setRoad(index, index - xCount, 1);
                    rm.setRoad(index - xCount, index, 1);
                }
                if (j <= 0) continue;
                rm.setRoad(index, index - 1, 1);
                rm.setRoad(index - 1, index, 1);
            }
        }
        return rm;
    }
}

