/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import rescuecore.CannotFindLocationException;
import rescuecore.HashMemory;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.objects.AmbulanceCenter;
import rescuecore.objects.AmbulanceTeam;
import rescuecore.objects.Building;
import rescuecore.objects.Civilian;
import rescuecore.objects.FireBrigade;
import rescuecore.objects.FireStation;
import rescuecore.objects.Humanoid;
import rescuecore.objects.Node;
import rescuecore.objects.PoliceForce;
import rescuecore.objects.PoliceOffice;
import rescuecore.objects.Refuge;
import rescuecore.objects.Road;
import rescuecore.tools.MapFiles;
import rescuecore.tools.RandomConfig;
import rescuecore.view.BuildingRenderer;
import rescuecore.view.HumanoidRenderer;
import rescuecore.view.Layer;
import rescuecore.view.Map;
import rescuecore.view.MapRenderer;
import rescuecore.view.ObjectInspector;
import rescuecore.view.ObjectSelector;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;

public class ScenarioMaker {
    private Road[] allRoads;
    private Node[] allNodes;
    private Building[] allBuildings;
    private Memory memory;
    private Map map;
    private Point pressPoint;
    private Point dragPoint;
    private Layer overlay;
    private Layer roadLayer;
    private Layer buildingLayer;
    private Layer humanoidLayer;
    private Tool tool;
    private JLabel currentTool;
    private ObjectInspector inspector;
    private ObjectSelector selector;
    private int nextID = 1000000;
    private Summary summary;

    public ScenarioMaker(Road[] roads, Node[] nodes, Building[] buildings, final boolean oldGIS) {
        int i;
        this.allRoads = roads;
        this.allNodes = nodes;
        this.allBuildings = buildings;
        this.memory = new HashMemory();
        for (i = 0; i < roads.length; ++i) {
            if (this.memory.lookup(roads[i].getID()) != null) {
                System.err.println("WARNING: Duplicate road ID: " + roads[i].getID() + ", this is is already used by " + this.memory.lookup(roads[i].getID()));
            }
            this.memory.add(roads[i], 0, this);
        }
        for (i = 0; i < nodes.length; ++i) {
            if (this.memory.lookup(nodes[i].getID()) != null) {
                System.err.println("WARNING: Duplicate node ID: " + nodes[i].getID() + ", this is is already used by " + this.memory.lookup(nodes[i].getID()));
            }
            this.memory.add(nodes[i], 0, this);
        }
        for (i = 0; i < buildings.length; ++i) {
            if (this.memory.lookup(buildings[i].getID()) != null) {
                System.err.println("WARNING: Duplicate building ID: " + buildings[i].getID() + ", this is is already used by " + this.memory.lookup(buildings[i].getID()));
            }
            this.memory.add(buildings[i], 0, this);
        }
        Arrays.sort(this.allRoads, new RoadSorter(this.memory));
        this.map = new Map(this.memory);
        this.roadLayer = Layer.createRoadLayer(this.memory);
        this.roadLayer.addRenderer(Road.class, new BigRoadRenderer());
        this.buildingLayer = Layer.createBuildingLayer(this.memory);
        this.buildingLayer.addRenderer(Building.class, new ImportantBuildingRenderer(BuildingRenderer.ordinaryBuildingRenderer()));
        this.humanoidLayer = Layer.createHumanoidLayer(this.memory);
        this.humanoidLayer.addRenderer(Humanoid.class, new HumanoidCountRenderer(HumanoidRenderer.ordinaryHumanoidRenderer()));
        this.map.addLayer(this.roadLayer);
        this.map.addLayer(this.buildingLayer);
        this.map.addLayer(this.humanoidLayer);
        this.map.addLayer(Layer.createNodeLayer(this.memory));
        this.overlay = Layer.createOverlayLayer("Overlay");
        this.map.addLayer(this.overlay);
        this.map.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScenarioMaker.this.handleClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ScenarioMaker.this.handlePress(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScenarioMaker.this.handleRelease(e);
            }
        });
        this.map.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ScenarioMaker.this.handleDrag(e);
            }
        });
        AbstractAction saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScenarioMaker.this.save(oldGIS);
            }
        };
        AbstractAction randomiseAction = new AbstractAction("Randomise"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScenarioMaker.this.randomise();
            }
        };
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenu tools = new JMenu("Tools");
        JMenu agentTools = new JMenu("Agents");
        JMenu fb = new JMenu("Fire brigades");
        JMenu fs = new JMenu("Fire stations");
        JMenu pf = new JMenu("Police forces");
        JMenu po = new JMenu("Police offices");
        JMenu at = new JMenu("Ambulance teams");
        JMenu ac = new JMenu("Ambulance centres");
        JMenu civ = new JMenu("Civilians");
        file.add(saveAction);
        tools.add(new ToolAction(Tool.PLACE_ROADS));
        tools.add(new ToolAction(Tool.CLEAR_ROADS));
        tools.addSeparator();
        tools.add(new ToolAction(Tool.PLACE_FIRES));
        tools.add(new ToolAction(Tool.CLEAR_FIRES));
        tools.add(new ToolAction(Tool.PLACE_REFUGES));
        tools.add(new ToolAction(Tool.CLEAR_REFUGES));
        tools.addSeparator();
        agentTools.add(fb);
        agentTools.add(fs);
        agentTools.add(pf);
        agentTools.add(po);
        agentTools.add(at);
        agentTools.add(ac);
        agentTools.add(civ);
        fb.add(new ToolAction(Tool.PLACE_FIRE_BRIGADES, "Place"));
        fb.add(new ToolAction(Tool.CLEAR_FIRE_BRIGADES, "Remove"));
        fs.add(new ToolAction(Tool.PLACE_FIRE_STATIONS, "Place"));
        fs.add(new ToolAction(Tool.CLEAR_FIRE_STATIONS, "Remove"));
        pf.add(new ToolAction(Tool.PLACE_POLICE_FORCES, "Place"));
        pf.add(new ToolAction(Tool.CLEAR_POLICE_FORCES, "Remove"));
        po.add(new ToolAction(Tool.PLACE_POLICE_OFFICES, "Place"));
        po.add(new ToolAction(Tool.CLEAR_POLICE_OFFICES, "Remove"));
        at.add(new ToolAction(Tool.PLACE_AMBULANCE_TEAMS, "Place"));
        at.add(new ToolAction(Tool.CLEAR_AMBULANCE_TEAMS, "Remove"));
        ac.add(new ToolAction(Tool.PLACE_AMBULANCE_CENTRES, "Place"));
        ac.add(new ToolAction(Tool.CLEAR_AMBULANCE_CENTRES, "Remove"));
        civ.add(new ToolAction(Tool.PLACE_CIVILIANS, "Place"));
        civ.add(new ToolAction(Tool.CLEAR_CIVILIANS, "Remove"));
        tools.add(agentTools);
        tools.addSeparator();
        tools.add(new ToolAction(Tool.INCREASE_IMPORTANCE));
        tools.add(new ToolAction(Tool.DECREASE_IMPORTANCE));
        tools.addSeparator();
        tools.add(randomiseAction);
        tools.addSeparator();
        tools.add(new ToolAction(Tool.INSPECTOR));
        menubar.add(file);
        menubar.add(tools);
        this.summary = new Summary();
        JFrame frame = new JFrame("Scenario Maker");
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)menubar, "Center");
        top.add((Component)this.summary, "East");
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this.map, "Center");
        JPanel side = new JPanel(new BorderLayout());
        this.currentTool = new JLabel("Current tool: Object inspector");
        this.inspector = new ObjectInspector(true);
        this.selector = new ObjectSelector(this.map);
        side.add((Component)this.currentTool, "North");
        side.add((Component)new JScrollPane(this.inspector), "Center");
        main.add((Component)side, "East");
        main.add((Component)top, "North");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(main);
        frame.pack();
        this.changeTool(Tool.INSPECTOR);
        frame.setVisible(true);
    }

    private int generateID() {
        int result;
        do {
            ++this.nextID;
        } while (this.memory.lookup(result) != null);
        return result;
    }

    private void changeTool(Tool t) {
        if (this.tool == t) {
            return;
        }
        this.tool = t;
        this.currentTool.setText("Current tool: " + t.getName());
        if (this.tool == Tool.INSPECTOR) {
            this.selector.addObjectSelectionListener(this.inspector);
        } else {
            this.selector.removeObjectSelectionListener(this.inspector);
        }
    }

    private void randomise() {
        RandomiseDialog r = new RandomiseDialog(null);
        r.pack();
        r.show();
        if (r.wasOK()) {
            int i;
            FireStation[] fireStations = new FireStation[r.getFireStations()];
            PoliceOffice[] policeOffices = new PoliceOffice[r.getPoliceOffices()];
            AmbulanceCenter[] ambulanceCentres = new AmbulanceCenter[r.getAmbulanceCentres()];
            Refuge[] refuges = new Refuge[r.getRefuges()];
            FireBrigade[] fireBrigades = new FireBrigade[r.getFireBrigades()];
            PoliceForce[] policeForces = new PoliceForce[r.getPoliceForces()];
            AmbulanceTeam[] ambulanceTeams = new AmbulanceTeam[r.getAmbulanceTeams()];
            Civilian[] civs = new Civilian[r.getCivs()];
            Building[] ordinary = RandomConfig.placeMotionlessObjects(fireStations, policeOffices, ambulanceCentres, refuges, this.allBuildings);
            RandomConfig.placeMovingObjects(fireBrigades, policeForces, ambulanceTeams, civs, this.allBuildings, new Road[0], this.allNodes, false, true);
            Building[] fires = RandomConfig.placeNormalFires(r.getFires(), ordinary);
            Collection<RescueObject> all = this.memory.getAllObjects();
            for (RescueObject next : all) {
                if (next instanceof Building) {
                    Building b = (Building)next;
                    b.setFieryness(0, 0, this);
                    this.convertBuilding(b, 32);
                }
                if (!(next instanceof Humanoid)) continue;
                this.memory.remove(next);
            }
            for (i = 0; i < fireStations.length; ++i) {
                this.memory.add(fireStations[i], 0);
            }
            for (i = 0; i < policeOffices.length; ++i) {
                this.memory.add(policeOffices[i], 0);
            }
            for (i = 0; i < ambulanceCentres.length; ++i) {
                this.memory.add(ambulanceCentres[i], 0);
            }
            for (i = 0; i < refuges.length; ++i) {
                this.memory.add(refuges[i], 0);
            }
            for (i = 0; i < fireBrigades.length; ++i) {
                fireBrigades[i].setID(this.generateID());
                this.memory.add(fireBrigades[i], 0);
            }
            for (i = 0; i < policeForces.length; ++i) {
                policeForces[i].setID(this.generateID());
                this.memory.add(policeForces[i], 0);
            }
            for (i = 0; i < ambulanceTeams.length; ++i) {
                ambulanceTeams[i].setID(this.generateID());
                this.memory.add(ambulanceTeams[i], 0);
            }
            for (i = 0; i < civs.length; ++i) {
                civs[i].setID(this.generateID());
                this.memory.add(civs[i], 0);
            }
            for (i = 0; i < fires.length; ++i) {
                fires[i].setFieryness(1, 0, null);
            }
            this.map.setMemory(this.memory);
            this.map.repaint();
            this.summary.update();
        }
    }

    private void handleClick(MouseEvent e) {
        if (this.dragPoint == null) {
            // empty if block
        }
    }

    private void handlePress(MouseEvent e) {
        this.pressPoint = e.getPoint();
    }

    private void handleRelease(MouseEvent e) {
        if (this.dragPoint == null) {
            Object[] all = this.map.getObjectsAtPoint(this.pressPoint);
            this.update(all, e);
        } else {
            int x1 = Math.min(this.pressPoint.x, this.dragPoint.x);
            int y1 = Math.min(this.pressPoint.y, this.dragPoint.y);
            int x2 = Math.max(this.pressPoint.x, this.dragPoint.x);
            int y2 = Math.max(this.pressPoint.y, this.dragPoint.y);
            Rectangle2D.Double box = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
            Object[] objects = this.map.getObjectsInArea(box);
            this.update(objects, e);
            this.pressPoint = null;
            this.dragPoint = null;
            this.overlay.removeAllObjects();
            this.map.repaint();
        }
    }

    private void handleDrag(MouseEvent e) {
        if (this.pressPoint != null) {
            this.dragPoint = e.getPoint();
            int dx = this.pressPoint.x - this.dragPoint.x;
            int dy = this.pressPoint.y - this.dragPoint.y;
            if (dx < 0) {
                dx = -dx;
            }
            if (dy < 0) {
                dy = -dy;
            }
            if (dx > 5 || dy > 5) {
                Rectangle r = new Rectangle(Math.min(this.pressPoint.x, this.dragPoint.x), Math.min(this.pressPoint.y, this.dragPoint.y), dx, dy);
                this.overlay.setObject(r);
                this.map.repaint();
            }
        }
    }

    private void update(Object[] os, MouseEvent e) {
        boolean change = false;
        switch (e.getButton()) {
            case 1: {
                change = this.leftClick(os);
            }
        }
        if (change) {
            this.map.setMemory(this.memory);
            this.map.repaint();
            this.summary.update();
        }
    }

    private boolean leftClick(Object[] os) {
        switch (this.tool) {
            case PLACE_ROADS: {
                return this.increaseBlock(os);
            }
            case CLEAR_ROADS: {
                return this.decreaseBlock(os);
            }
            case PLACE_FIRES: {
                return this.placeFires(os);
            }
            case CLEAR_FIRES: {
                return this.clearFires(os);
            }
            case PLACE_REFUGES: {
                return this.placeRefuges(os);
            }
            case CLEAR_REFUGES: {
                return this.clearRefuges(os);
            }
            case PLACE_FIRE_BRIGADES: {
                return this.addAgent(os, 66);
            }
            case CLEAR_FIRE_BRIGADES: {
                return this.removeAgent(os, 66);
            }
            case PLACE_POLICE_FORCES: {
                return this.addAgent(os, 68);
            }
            case CLEAR_POLICE_FORCES: {
                return this.removeAgent(os, 68);
            }
            case PLACE_AMBULANCE_TEAMS: {
                return this.addAgent(os, 67);
            }
            case CLEAR_AMBULANCE_TEAMS: {
                return this.removeAgent(os, 67);
            }
            case PLACE_CIVILIANS: {
                return this.addAgent(os, 64);
            }
            case CLEAR_CIVILIANS: {
                return this.removeAgent(os, 64);
            }
            case PLACE_FIRE_STATIONS: {
                return this.addCentre(os, 34);
            }
            case CLEAR_FIRE_STATIONS: {
                return this.removeCentre(os, 34);
            }
            case PLACE_POLICE_OFFICES: {
                return this.addCentre(os, 36);
            }
            case CLEAR_POLICE_OFFICES: {
                return this.removeCentre(os, 36);
            }
            case PLACE_AMBULANCE_CENTRES: {
                return this.addCentre(os, 35);
            }
            case CLEAR_AMBULANCE_CENTRES: {
                return this.removeCentre(os, 35);
            }
            case INCREASE_IMPORTANCE: {
                return this.increaseImportance(os);
            }
            case DECREASE_IMPORTANCE: {
                return this.decreaseImportance(os);
            }
        }
        return false;
    }

    private boolean increaseBlock(Object[] roads) {
        boolean changed = false;
        for (int i = 0; i < roads.length; ++i) {
            if (!(roads[i] instanceof Road)) continue;
            changed = this.increaseBlock((Road)roads[i]) | changed;
        }
        return changed;
    }

    private boolean decreaseBlock(Object[] roads) {
        boolean changed = false;
        for (int i = 0; i < roads.length; ++i) {
            if (!(roads[i] instanceof Road)) continue;
            changed = this.decreaseBlock((Road)roads[i]) | changed;
        }
        return changed;
    }

    private boolean increaseBlock(Road road) {
        int lanes = road.getLinesToHead();
        int blocked = lanes - ScenarioMaker.freeLanes(road);
        if (blocked == lanes) {
            return false;
        }
        this.setBlockedLanes(road, blocked + 1);
        return true;
    }

    private boolean decreaseBlock(Road road) {
        int lanes = road.getLinesToHead();
        int blocked = lanes - ScenarioMaker.freeLanes(road);
        if (blocked == 0) {
            return false;
        }
        this.setBlockedLanes(road, blocked - 1);
        return true;
    }

    private void setBlockedLanes(Road road, int blocked) {
        int width = road.getWidth();
        int laneWidth = width / (road.getLinesToHead() + road.getLinesToTail());
        int blockNeeded = blocked * laneWidth * 2;
        if (blockNeeded > width) {
            System.out.println("Trying to set block to " + blockNeeded + " but width is only " + width);
            blockNeeded = width;
        }
        road.setBlock(blockNeeded, 0, this);
        int newBlock = road.getLinesToHead() - ScenarioMaker.freeLanes(road);
        if (newBlock != blocked) {
            System.out.println("We have " + newBlock + " blocked lanes instead of " + blocked + "!");
        }
    }

    private boolean placeFires(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Building)) continue;
            changed = this.placeFire((Building)os[i]) | changed;
        }
        return changed;
    }

    private boolean clearFires(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Building)) continue;
            changed = this.clearFire((Building)os[i]) | changed;
        }
        return changed;
    }

    private boolean placeFire(Building b) {
        if (b.getFieryness() == 0) {
            b.setFieryness(1, 0, this);
            return true;
        }
        return false;
    }

    private boolean clearFire(Building b) {
        if (b.getFieryness() != 0) {
            b.setFieryness(0, 0, this);
            return true;
        }
        return false;
    }

    private boolean placeRefuges(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Building)) continue;
            changed = this.setRefuge((Building)os[i]) | changed;
        }
        return changed;
    }

    private boolean clearRefuges(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Building)) continue;
            changed = this.clearRefuge((Building)os[i]) | changed;
        }
        return changed;
    }

    private boolean increaseImportance(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Building)) continue;
            Building b = (Building)os[i];
            b.setImportance(b.getImportance() + 1, 0, null);
            changed = true;
        }
        return changed;
    }

    private boolean decreaseImportance(Object[] os) {
        boolean changed = false;
        for (int i = 0; i < os.length; ++i) {
            Building b;
            if (!(os[i] instanceof Building) || (b = (Building)os[i]).getImportance() <= 1) continue;
            b.setImportance(b.getImportance() - 1, 0, null);
            changed = true;
        }
        return changed;
    }

    private boolean setRefuge(Building b) {
        if (b.isRefuge()) {
            return false;
        }
        this.convertBuilding(b, 33);
        return true;
    }

    private boolean clearRefuge(Building b) {
        if (!b.isRefuge()) {
            return false;
        }
        this.convertBuilding(b, 32);
        return true;
    }

    private boolean addAgent(Object[] os, int type) {
        Humanoid result;
        int position = 0;
        Road road = null;
        for (Object next : os) {
            if (!(next instanceof Building) && !(next instanceof Road) && !(next instanceof Node)) continue;
            position = ((RescueObject)next).getID();
            if (!(next instanceof Road)) continue;
            road = (Road)next;
        }
        if (position == 0) {
            return false;
        }
        switch (type) {
            case 66: {
                result = new FireBrigade();
                break;
            }
            case 68: {
                result = new PoliceForce();
                break;
            }
            case 67: {
                result = new AmbulanceTeam();
                break;
            }
            case 64: {
                result = new Civilian();
                break;
            }
            default: {
                return false;
            }
        }
        result.setID(this.generateID());
        result.setPosition(position, 0, this);
        if (road != null) {
            result.setPositionExtra(road.getLength() / 2, 0, this);
        }
        this.memory.add(result, 0, this);
        return true;
    }

    private boolean removeAgent(Object[] os, int type) {
        for (Object next : os) {
            RescueObject r;
            if (!(next instanceof RescueObject) || (r = (RescueObject)next).getType() != type) continue;
            this.memory.remove(r);
            return true;
        }
        return false;
    }

    private boolean addCentre(Object[] os, int type) {
        for (Object next : os) {
            Building b;
            if (!(next instanceof Building) || !(b = (Building)next).isOrdinaryBuilding()) continue;
            this.convertBuilding(b, type);
            return true;
        }
        return false;
    }

    private boolean removeCentre(Object[] os, int type) {
        for (Object next : os) {
            Building b;
            if (!(next instanceof Building) || (b = (Building)next).getType() != type) continue;
            this.convertBuilding(b, 32);
            return true;
        }
        return false;
    }

    private void convertBuilding(Building b, int type) {
        Building replace;
        if (b.getType() == type) {
            return;
        }
        switch (type) {
            case 32: {
                replace = new Building(b);
                break;
            }
            case 33: {
                replace = new Refuge(b);
                break;
            }
            case 34: {
                replace = new FireStation(b);
                break;
            }
            case 36: {
                replace = new PoliceOffice(b);
                break;
            }
            case 35: {
                replace = new AmbulanceCenter(b);
                break;
            }
            default: {
                System.err.println("Can't convert to type " + type);
                return;
            }
        }
        replace.setID(b.getID());
        this.memory.remove(b);
        this.memory.add(replace, 0, this);
    }

    private void save(boolean oldGIS) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(new File("blockades.lst")));
            for (int i = 0; i < this.allRoads.length; ++i) {
                out.println(this.allRoads[i].getBlock());
            }
            out.flush();
            out.close();
            out = new PrintWriter(new FileWriter(new File("gisini.txt")));
            if (oldGIS) {
                this.writeOldGIS(out, this.getFireStations(), this.getPoliceOffices(), this.getAmbulanceCenters(), this.getFireBrigades(), this.getPoliceForces(), this.getAmbulanceTeams(), this.getCivilians(), this.getRefuges(), this.getFires());
            } else {
                MapFiles.writeGISMotionlessObjects(out, this.getFireStations(), this.getPoliceOffices(), this.getAmbulanceCenters(), this.getRefuges());
                MapFiles.writeGISMovingObjects(out, this.getFireBrigades(), this.getPoliceForces(), this.getAmbulanceTeams(), this.getCivilians(), this.memory);
                MapFiles.writeGISFires(out, this.getFires());
                MapFiles.writeGISImportantBuildings(out, this.getImportantBuildings());
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeOldGIS(PrintWriter out, FireStation[] fs, PoliceOffice[] po, AmbulanceCenter[] ac, FireBrigade[] f, PoliceForce[] p, AmbulanceTeam[] a, Civilian[] c, Refuge[] r, Building[] fires) {
        int i;
        out.println("[MotionLessObject]");
        out.println("FireStationNum=" + fs.length);
        out.println("PoliceOfficeNum=" + po.length);
        out.println("AmbulanceCenterNum=" + ac.length);
        out.println("RefugeNum=" + r.length);
        for (i = 0; i < fs.length; ++i) {
            out.println("FireStation" + i + "=0,0," + fs[i].getID() + ",0");
        }
        for (i = 0; i < po.length; ++i) {
            out.println("PoliceOffice" + i + "=0,0," + po[i].getID() + ",0");
        }
        for (i = 0; i < ac.length; ++i) {
            out.println("AmbulanceCenter" + i + "=0,0," + ac[i].getID() + ",0");
        }
        for (i = 0; i < r.length; ++i) {
            out.println("Refuge" + i + "=0,0," + r[i].getID() + ",0");
        }
        out.println("[MovingObject]");
        out.println("FireBrigadeNum=" + f.length);
        out.println("PoliceForceNum=" + p.length);
        out.println("AmbulanceTeamNum=" + a.length);
        out.println("CivilianNum=" + c.length);
        for (i = 0; i < f.length; ++i) {
            out.println("FireBrigade" + i + "=0,0," + f[i].getPosition() + ",0,0," + f[i].getPositionExtra() + ",0");
        }
        for (i = 0; i < p.length; ++i) {
            out.println("PoliceForce" + i + "=0,0," + p[i].getPosition() + ",0,0," + p[i].getPositionExtra() + ",0");
        }
        for (i = 0; i < a.length; ++i) {
            out.println("AmbulanceTeam" + i + "=0,0," + a[i].getPosition() + ",0,0," + a[i].getPositionExtra() + ",0");
        }
        for (i = 0; i < c.length; ++i) {
            out.println("Civilian" + i + "=0,0," + c[i].getPosition() + ",0,0," + c[i].getPositionExtra() + ",0");
        }
        out.println("[Fires]");
        out.println("FirePointNum=" + fires.length);
        for (i = 0; i < fires.length; ++i) {
            out.println("FirePoint" + i + "=0,0," + fires[i].getID() + ",0");
        }
    }

    private FireStation[] getFireStations() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(34);
        FireStation[] result = new FireStation[objects.size()];
        objects.toArray(result);
        return result;
    }

    private PoliceOffice[] getPoliceOffices() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(36);
        PoliceOffice[] result = new PoliceOffice[objects.size()];
        objects.toArray(result);
        return result;
    }

    private AmbulanceCenter[] getAmbulanceCenters() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(35);
        AmbulanceCenter[] result = new AmbulanceCenter[objects.size()];
        objects.toArray(result);
        return result;
    }

    private Refuge[] getRefuges() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(33);
        Refuge[] result = new Refuge[objects.size()];
        objects.toArray(result);
        return result;
    }

    private FireBrigade[] getFireBrigades() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(66);
        FireBrigade[] result = new FireBrigade[objects.size()];
        objects.toArray(result);
        return result;
    }

    private PoliceForce[] getPoliceForces() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(68);
        PoliceForce[] result = new PoliceForce[objects.size()];
        objects.toArray(result);
        return result;
    }

    private AmbulanceTeam[] getAmbulanceTeams() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(67);
        AmbulanceTeam[] result = new AmbulanceTeam[objects.size()];
        objects.toArray(result);
        return result;
    }

    private Civilian[] getCivilians() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(64);
        Civilian[] result = new Civilian[objects.size()];
        objects.toArray(result);
        return result;
    }

    private Building[] getFires() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(32, 33, 34, 35, 36);
        HashSet<Building> fires = new HashSet<Building>();
        for (RescueObject next : objects) {
            Building b = (Building)next;
            if (b.getFieryness() <= 0) continue;
            fires.add(b);
        }
        return fires.toArray(new Building[0]);
    }

    private Building[] getImportantBuildings() {
        Collection<RescueObject> objects = this.memory.getObjectsOfType(32, 33, 34, 35, 36);
        HashSet<Building> important = new HashSet<Building>();
        for (RescueObject next : objects) {
            Building b = (Building)next;
            if (b.getImportance() <= 1) continue;
            important.add(b);
        }
        return important.toArray(new Building[0]);
    }

    private static int freeLanes(Road road) {
        double blockWidth = (double)road.getBlock() / 2.0;
        double lineWidth = (double)road.getWidth() / ((double)road.getLinesToHead() + (double)road.getLinesToTail());
        double linesBlockedRate = blockWidth / lineWidth;
        return road.getLinesToHead() - (int)Math.floor(linesBlockedRate + 0.5);
    }

    public static void main(String[] args) {
        boolean oldGIS = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("--oldgis")) {
                ScenarioMaker.printUsage();
                return;
            }
            oldGIS = true;
        }
        try {
            Road[] r = MapFiles.loadRoads("road.bin");
            Node[] n = MapFiles.loadNodes("node.bin");
            Building[] b = MapFiles.loadBuildings("building.bin");
            new ScenarioMaker(r, n, b, oldGIS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: ScenarioMaker [--oldgis]");
    }

    private class ToolAction
    extends AbstractAction {
        private Tool tool;

        public ToolAction(Tool t) {
            this(t, t.getName());
        }

        public ToolAction(Tool t, String name) {
            super(name);
            this.tool = t;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScenarioMaker.this.changeTool(this.tool);
        }
    }

    private class RandomiseDialog
    extends JDialog {
        private JSpinner civsField;
        private JSpinner fireField;
        private JSpinner policeField;
        private JSpinner ambulanceField;
        private JSpinner fireStationField;
        private JSpinner policeOfficeField;
        private JSpinner ambulanceCenterField;
        private JSpinner refugeField;
        private JSpinner firesField;
        private JButton ok;
        private JButton cancel;
        private boolean wasOK;

        public RandomiseDialog(Frame owner) {
            super(owner, "Randomise config", true);
            this.civsField = new JSpinner(new SpinnerNumberModel(70, 50, 80, 1));
            this.fireField = new JSpinner(new SpinnerNumberModel(10, 5, 15, 1));
            this.policeField = new JSpinner(new SpinnerNumberModel(10, 5, 15, 1));
            this.ambulanceField = new JSpinner(new SpinnerNumberModel(8, 5, 10, 1));
            this.fireStationField = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
            this.policeOfficeField = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
            this.ambulanceCenterField = new JSpinner(new SpinnerNumberModel(1, 1, 11, 1));
            this.refugeField = new JSpinner(new SpinnerNumberModel(4, 1, 5, 1));
            this.firesField = new JSpinner(new SpinnerNumberModel(4, 2, 8, 1));
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            JPanel main = new JPanel(layout);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 17;
            JLabel l = new JLabel("Fire brigades");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Police forces");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Ambulance teams");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Civilians");
            layout.setConstraints(l, c);
            main.add(l);
            c.gridy = 0;
            c.gridx = 2;
            l = new JLabel("Fire stations");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Police offices");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Ambulance centres");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Refuges");
            layout.setConstraints(l, c);
            main.add(l);
            ++c.gridy;
            l = new JLabel("Fires");
            layout.setConstraints(l, c);
            main.add(l);
            c.gridy = 0;
            c.gridx = 1;
            layout.setConstraints(this.fireField, c);
            main.add(this.fireField);
            ++c.gridy;
            layout.setConstraints(this.policeField, c);
            main.add(this.policeField);
            ++c.gridy;
            layout.setConstraints(this.ambulanceField, c);
            main.add(this.ambulanceField);
            ++c.gridy;
            layout.setConstraints(this.civsField, c);
            main.add(this.civsField);
            c.gridy = 0;
            c.gridx = 3;
            layout.setConstraints(this.fireStationField, c);
            main.add(this.fireStationField);
            ++c.gridy;
            layout.setConstraints(this.policeOfficeField, c);
            main.add(this.policeOfficeField);
            ++c.gridy;
            layout.setConstraints(this.ambulanceCenterField, c);
            main.add(this.ambulanceCenterField);
            ++c.gridy;
            layout.setConstraints(this.refugeField, c);
            main.add(this.refugeField);
            ++c.gridy;
            layout.setConstraints(this.firesField, c);
            main.add(this.firesField);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.anchor = 10;
            layout.setConstraints(this.ok, c);
            main.add(this.ok);
            c.gridx = 2;
            layout.setConstraints(this.cancel, c);
            main.add(this.cancel);
            this.setContentPane(main);
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RandomiseDialog.this.wasOK = true;
                    RandomiseDialog.this.setVisible(false);
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RandomiseDialog.this.wasOK = false;
                    RandomiseDialog.this.setVisible(false);
                }
            });
        }

        public boolean wasOK() {
            return this.wasOK;
        }

        public int getFireBrigades() {
            return ((Number)this.fireField.getValue()).intValue();
        }

        public int getFireStations() {
            return ((Number)this.fireStationField.getValue()).intValue();
        }

        public int getPoliceForces() {
            return ((Number)this.policeField.getValue()).intValue();
        }

        public int getPoliceOffices() {
            return ((Number)this.policeOfficeField.getValue()).intValue();
        }

        public int getAmbulanceTeams() {
            return ((Number)this.ambulanceField.getValue()).intValue();
        }

        public int getAmbulanceCentres() {
            return ((Number)this.ambulanceCenterField.getValue()).intValue();
        }

        public int getCivs() {
            return ((Number)this.civsField.getValue()).intValue();
        }

        public int getRefuges() {
            return ((Number)this.refugeField.getValue()).intValue();
        }

        public int getFires() {
            return ((Number)this.firesField.getValue()).intValue();
        }
    }

    private class RoadSorter
    implements Comparator {
        private Memory m;

        public RoadSorter(Memory m) {
            this.m = m;
        }

        public int compare(Object o1, Object o2) {
            Road r1 = (Road)o1;
            Road r2 = (Road)o2;
            Node h1 = (Node)this.m.lookup(r1.getHead());
            Node t1 = (Node)this.m.lookup(r1.getTail());
            Node h2 = (Node)this.m.lookup(r2.getHead());
            Node t2 = (Node)this.m.lookup(r2.getTail());
            int x1 = (h1.getX() + t1.getX()) / 2;
            int y1 = (h1.getY() + t1.getY()) / 2;
            int x2 = (h2.getX() + t2.getX()) / 2;
            int y2 = (h2.getY() + t2.getY()) / 2;
            if (x1 < x2) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            if (y1 < y2) {
                return -1;
            }
            if (y2 > y1) {
                return 1;
            }
            return 0;
        }
    }

    private static class HumanoidCountRenderer
    implements MapRenderer {
        private MapRenderer downstream;

        public HumanoidCountRenderer(MapRenderer downstream) {
            this.downstream = downstream;
        }

        @Override
        public boolean canRender(Object o) {
            return o instanceof Humanoid && this.downstream.canRender(o);
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Shape shape = this.downstream.render(o, memory, g, transform);
            int position = ((Humanoid)o).getPosition();
            int count = 0;
            for (RescueObject next : memory.getObjectsOfType(64, 67, 66, 68)) {
                Humanoid h = (Humanoid)next;
                if (h.getPosition() != position) continue;
                ++count;
            }
            if (count > 1) {
                g.setColor(Color.black);
                Rectangle bounds = shape.getBounds();
                FontMetrics metrics = g.getFontMetrics();
                String s = "" + count;
                int width = metrics.stringWidth(s);
                int centerX = bounds.x + bounds.width / 2;
                g.drawString(s, centerX - width / 2, bounds.y + bounds.height / 2 + metrics.getDescent());
            }
            return shape;
        }
    }

    private static class ImportantBuildingRenderer
    implements MapRenderer {
        private BuildingRenderer downstream;

        public ImportantBuildingRenderer(BuildingRenderer downstream) {
            this.downstream = downstream;
        }

        @Override
        public boolean canRender(Object o) {
            return o instanceof Building && this.downstream.canRender(o);
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Shape shape = this.downstream.render(o, memory, g, transform);
            int importance = ((Building)o).getImportance();
            if (importance > 1) {
                g.setColor(Color.black);
                Rectangle bounds = shape.getBounds();
                FontMetrics metrics = g.getFontMetrics();
                String s = "" + importance;
                int width = metrics.stringWidth(s);
                int centerX = bounds.x + bounds.width / 2;
                g.drawString(s, centerX - width / 2, bounds.y + bounds.height / 2 + metrics.getDescent());
            }
            return shape;
        }
    }

    private static class BigRoadRenderer
    implements MapRenderer {
        private BigRoadRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o instanceof Road;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Road road = (Road)o;
            Node roadHead = (Node)memory.lookup(road.getHead());
            Node roadTail = (Node)memory.lookup(road.getTail());
            int headX = transform.toScreenX(roadHead.getX());
            int headY = transform.toScreenY(roadHead.getY());
            int tailX = transform.toScreenX(roadTail.getX());
            int tailY = transform.toScreenY(roadTail.getY());
            Shape shape = new Line2D.Double(headX, headY, tailX, tailY);
            shape = new BasicStroke(10.0f).createStrokedShape(shape);
            Color c = Color.BLACK;
            int lanes = road.getLinesToHead();
            int free = ScenarioMaker.freeLanes(road);
            c = Color.ORANGE;
            if (free == 0) {
                c = Color.BLACK;
            }
            if (free == lanes) {
                c = Color.WHITE;
            }
            RenderTools.setLineMode(g, 0, c);
            ((Graphics2D)g).draw(shape);
            return shape;
        }
    }

    private class Summary
    extends JLabel {
        public Summary() {
            super("FB: 0, FS: 0, PF: 0, PO: 0, AT: 0, AC: 0, Civ: 0");
        }

        public void update() {
            int fb = ScenarioMaker.this.memory.getObjectsOfType(66).size();
            int fs = ScenarioMaker.this.memory.getObjectsOfType(34).size();
            int pf = ScenarioMaker.this.memory.getObjectsOfType(68).size();
            int po = ScenarioMaker.this.memory.getObjectsOfType(36).size();
            int at = ScenarioMaker.this.memory.getObjectsOfType(67).size();
            int ac = ScenarioMaker.this.memory.getObjectsOfType(35).size();
            int civ = ScenarioMaker.this.memory.getObjectsOfType(64).size();
            this.setText("FB: " + fb + ", FS: " + fs + ", PF: " + pf + ", PO: " + po + ", AT: " + at + ", AC: " + ac + ", Civ: " + civ);
        }
    }

    private static enum Tool {
        PLACE_ROADS("Place blocked roads"),
        CLEAR_ROADS("Remove blocked roads"),
        PLACE_FIRES("Place fires"),
        CLEAR_FIRES("Remove fires"),
        PLACE_REFUGES("Place refuges"),
        CLEAR_REFUGES("Remove refuges"),
        PLACE_FIRE_BRIGADES("Place fire brigades"),
        CLEAR_FIRE_BRIGADES("Remove fire brigades"),
        PLACE_FIRE_STATIONS("Place fire stations"),
        CLEAR_FIRE_STATIONS("Remove fire stations"),
        PLACE_POLICE_FORCES("Place Police forces"),
        CLEAR_POLICE_FORCES("Remove police forces"),
        PLACE_POLICE_OFFICES("Place police offices"),
        CLEAR_POLICE_OFFICES("Remove police offices"),
        PLACE_AMBULANCE_TEAMS("Place ambulance teams"),
        CLEAR_AMBULANCE_TEAMS("Remove ambulance teams"),
        PLACE_AMBULANCE_CENTRES("Place ambulance centres"),
        CLEAR_AMBULANCE_CENTRES("Remove ambulance centres"),
        PLACE_CIVILIANS("Place civilians"),
        CLEAR_CIVILIANS("Remove civilians"),
        INCREASE_IMPORTANCE("Increase building importance"),
        DECREASE_IMPORTANCE("Decrease building importance"),
        INSPECTOR("Object inspector");

        private String name;

        private Tool(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

