/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import rescuecore.tools.simulationrunner.RescueProcess;
import rescuecore.tools.simulationrunner.XMLDecodingException;
import rescuecore.tools.simulationrunner.XMLDocumentParser;
import rescuecore.tools.simulationrunner.XMLTag;

public class Session {
    private String name;
    private String configFile;
    private String roadFile;
    private String nodeFile;
    private String buildingFile;
    private String gisFile;
    private String shindoFile;
    private String galFile;
    private RescueProcess[] simulatorComponents;

    public Session(String xmlFile) throws IOException, XMLDecodingException {
        XMLTag tag = XMLDocumentParser.parse(new BufferedReader(new FileReader(xmlFile)));
        XMLTag nameTag = tag.getChild("name", false);
        XMLTag configTag = tag.getChild("config");
        XMLTag roadTag = tag.getChild("road");
        XMLTag nodeTag = tag.getChild("node");
        XMLTag buildingTag = tag.getChild("building");
        XMLTag gisTag = tag.getChild("gis");
        XMLTag shindoTag = tag.getChild("shindo");
        XMLTag galTag = tag.getChild("gal");
        this.name = nameTag.getText();
        this.configFile = configTag == null ? "config.txt" : configTag.getText();
        this.roadFile = roadTag == null ? "road.bin" : roadTag.getText();
        this.nodeFile = nodeTag == null ? "node.bin" : nodeTag.getText();
        this.buildingFile = buildingTag == null ? "building.bin" : buildingTag.getText();
        this.gisFile = gisTag == null ? "gis.ini" : gisTag.getText();
        this.shindoFile = shindoTag == null ? "shindopolydata.dat" : shindoTag.getText();
        this.galFile = galTag == null ? "galpolydata.dat" : galTag.getText();
        XMLTag simulatorsTag = tag.getChild("simulators", false);
        List simulators = simulatorsTag.getChildren("simulator");
        this.simulatorComponents = new RescueProcess[simulators.size()];
        int i = 0;
        for (XMLTag next : simulators) {
            XMLTag nextName = next.getChild("name", false);
            XMLTag commandLine = next.getChild("commandline", false);
            XMLTag trigger = next.getChild("trigger");
            this.simulatorComponents[i++] = new RescueProcess(nextName.getText(), commandLine.getText(), trigger == null ? null : trigger.getText(), null);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getRoadFile() {
        return this.roadFile;
    }

    public String getNodeFile() {
        return this.nodeFile;
    }

    public String getBuildingFile() {
        return this.buildingFile;
    }

    public String getGalFile() {
        return this.galFile;
    }

    public String getShindoFile() {
        return this.shindoFile;
    }

    public String getGisFile() {
        return this.gisFile;
    }

    public RescueProcess[] getProcesses() {
        return this.simulatorComponents;
    }
}

