/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rescuecore.tools.simulationrunner.XMLDecodingException;

public class XMLTag {
    private XMLTag parent;
    private List children;
    private String name;
    private Map attributes;
    private StringBuffer textBuffer;
    private String text;

    public XMLTag(String name) {
        this.name = name;
        this.attributes = new HashMap();
        this.textBuffer = new StringBuffer();
        this.children = new ArrayList();
    }

    public XMLTag(String name, String text) {
        this.name = name;
        this.attributes = new HashMap();
        this.textBuffer = new StringBuffer();
        this.children = new ArrayList();
        this.appendText(text);
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public void appendText(String s) {
        this.textBuffer.append(s);
        this.text = null;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.textBuffer.toString();
        }
        return this.text;
    }

    public void setParent(XMLTag parent) {
        this.parent = parent;
    }

    public XMLTag getParent() {
        return this.parent;
    }

    public void addChild(XMLTag child) {
        this.children.add(child);
        child.parent = this;
    }

    public List getChildren() {
        return this.children;
    }

    public List getChildren(String name) {
        ArrayList<XMLTag> result = new ArrayList<XMLTag>();
        for (XMLTag next : this.children) {
            if (!next.name.equals(name)) continue;
            result.add(next);
        }
        return result;
    }

    public XMLTag getChild(String name) throws XMLDecodingException {
        return this.getChild(name, true);
    }

    public XMLTag getChild(String name, boolean canBeNull) throws XMLDecodingException {
        List allChildren = this.getChildren(name);
        if (allChildren.size() > 1) {
            throw new XMLDecodingException(this + " should have no more than one child called " + name);
        }
        if (allChildren.size() == 0) {
            if (canBeNull) {
                return null;
            }
            throw new XMLDecodingException(this + " should have exactly one child called " + name);
        }
        return (XMLTag)allChildren.get(0);
    }

    public void prettyPrint(PrintWriter out, String prefix) {
        XMLTag.prettyPrint(this, out, prefix);
    }

    public void print(PrintWriter out) {
        XMLTag.print(this, out);
    }

    public String toString() {
        StringWriter string = new StringWriter();
        PrintWriter out = new PrintWriter(string);
        this.print(out);
        return string.toString();
    }

    public static void print(XMLTag tag, PrintWriter out) {
        if (tag.children.size() == 0 && tag.attributes.size() == 0 && tag.getText().equals("")) {
            out.print("<");
            out.print(tag.name);
            out.print("/>");
            return;
        }
        out.print("<");
        out.print(tag.name);
        Iterator<Object> it = tag.attributes.keySet().iterator();
        while (it.hasNext()) {
            out.print(" ");
            String name = (String)it.next();
            String value = (String)tag.attributes.get(name);
            char quoteChar = '\"';
            if (value.indexOf("\"") != -1) {
                quoteChar = '\'';
            }
            out.print(name);
            out.print("=");
            out.print(quoteChar);
            out.print(value);
            out.print(quoteChar);
        }
        out.print(">");
        out.print(tag.getText());
        it = tag.children.iterator();
        while (it.hasNext()) {
            XMLTag.print((XMLTag)it.next(), out);
        }
        out.print("</");
        out.print(tag.name);
        out.print(">");
    }

    public static void prettyPrint(XMLTag tag, PrintWriter out) {
        XMLTag.prettyPrint(tag, out, "");
    }

    public static void prettyPrint(XMLTag tag, PrintWriter out, String prefix) {
        if (tag.children.size() == 0 && tag.attributes.size() == 0 && tag.getText().equals("")) {
            out.print(prefix);
            out.print("<");
            out.print(tag.name);
            out.println("/>");
            return;
        }
        out.print(prefix);
        out.print("<");
        out.print(tag.name);
        Iterator it = tag.attributes.keySet().iterator();
        while (it.hasNext()) {
            out.print(" ");
            String name = (String)it.next();
            String value = (String)tag.attributes.get(name);
            char quoteChar = '\"';
            if (value.indexOf("\"") != -1) {
                quoteChar = '\'';
            }
            out.print(name);
            out.print("=");
            out.print(quoteChar);
            out.print(value);
            out.print(quoteChar);
        }
        out.print(">");
        String text = tag.getText();
        if (text == null || text.trim().equals("")) {
            out.println();
        } else {
            out.print(text);
        }
        if (tag.children.size() > 0) {
            String childPrefix = prefix + "  ";
            Iterator it2 = tag.children.iterator();
            while (it2.hasNext()) {
                XMLTag.prettyPrint((XMLTag)it2.next(), out, childPrefix);
            }
            out.print(prefix);
        }
        out.print("</");
        out.print(tag.name);
        out.println(">");
    }
}

