/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rescuecore.Memory;
import rescuecore.view.Map;
import rescuecore.view.ObjectInspector;
import rescuecore.view.ObjectSelector;

public class Display
extends JPanel {
    private Map map;
    private ObjectInspector inspector;
    private JLabel timestep;
    private JLabel score;
    private static final NumberFormat FORMAT = NumberFormat.getInstance();

    public static Display showDisplay(Memory m) {
        return Display.showDisplay(Map.defaultMap(m));
    }

    public static Display showDisplay(Map map) {
        final JFrame frame = new JFrame();
        Display result = new Display(map);
        frame.setContentPane(result);
        frame.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        return result;
    }

    public Display(Memory m) {
        this(Map.defaultMap(m));
    }

    public Display(Map map) {
        super(new BorderLayout());
        this.map = map;
        this.inspector = new ObjectInspector();
        this.timestep = new JLabel("300");
        this.score = new JLabel("100.0000");
        JPanel top = new JPanel(new FlowLayout());
        top.add(new JLabel("Time: "));
        top.add(this.timestep);
        top.add(new JLabel("Score: "));
        top.add(this.score);
        this.add((Component)top, "North");
        this.add((Component)this.inspector, "East");
        this.add((Component)map, "Center");
        ObjectSelector selector = new ObjectSelector();
        map.addMouseListener(selector);
        selector.addObjectSelectionListener(this.inspector);
    }

    public Map getMap() {
        return this.map;
    }

    public void setTimestep(int t) {
        this.timestep.setText("" + t);
    }

    public void setScore(double d) {
        this.score.setText(FORMAT.format(d));
    }

    static {
        FORMAT.setMaximumFractionDigits(4);
        FORMAT.setMinimumFractionDigits(0);
        FORMAT.setMaximumIntegerDigits(100);
        FORMAT.setMinimumIntegerDigits(1);
    }
}

