/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import rescuecore.Handy;
import rescuecore.Property;
import rescuecore.RescueObject;
import rescuecore.event.PropertyChangedEvent;
import rescuecore.event.PropertyListener;
import rescuecore.view.ObjectSelectionEvent;
import rescuecore.view.ObjectSelectionListener;

public class ObjectInspector
extends JPanel
implements ObjectSelectionListener,
PropertyListener {
    private PropertiesTableModel model = new PropertiesTableModel();
    private RescueObject view;
    private int[] properties;
    private boolean showUpdateData;
    private static final int COLUMN_PROPERTY = 0;
    private static final int COLUMN_VALUE = 1;
    private static final int COLUMN_LAST_UPDATE = 2;
    private static final int COLUMN_UPDATE_SOURCE = 3;
    private static final int NUM_COLUMNS = 4;
    private static final int NUM_BASIC_COLUMNS = 2;

    public ObjectInspector() {
        this(true);
    }

    public ObjectInspector(boolean showUpdates) {
        super(new BorderLayout());
        this.add((Component)new JScrollPane(new JTable(this.model)), "Center");
        this.showUpdateData = showUpdates;
    }

    @Override
    public void objectSelected(ObjectSelectionEvent e) {
        if (e.getSelectedObject() == null) {
            return;
        }
        if (e.getSelectedObject() instanceof RescueObject) {
            this.showObject((RescueObject)e.getSelectedObject());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedEvent event) {
        this.model.refresh();
    }

    public void showObject(RescueObject o) {
        if (this.view != null) {
            this.view.removePropertyListener(this);
        }
        this.view = o;
        this.properties = this.view == null ? null : this.view.getKnownPropertyTypes();
        this.model.refresh();
        if (this.view != null) {
            this.view.addPropertyListener(this);
        }
    }

    private class PropertiesTableModel
    extends AbstractTableModel {
        private PropertiesTableModel() {
        }

        public void refresh() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return ObjectInspector.this.view == null ? 0 : ObjectInspector.this.properties.length + 2;
        }

        @Override
        public int getColumnCount() {
            return ObjectInspector.this.showUpdateData ? 4 : 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Value";
                }
                case 2: {
                    return "Last update";
                }
                case 3: {
                    return "Update source";
                }
            }
            throw new IllegalArgumentException("Unknown column: " + col);
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (row == 0) {
                        return "ID";
                    }
                    if (row == 1) {
                        return "Type";
                    }
                    return Handy.getPropertyName(ObjectInspector.this.properties[row - 2]);
                }
                case 1: {
                    if (row == 0) {
                        return "" + ObjectInspector.this.view.getID();
                    }
                    if (row == 1) {
                        return Handy.getTypeName(ObjectInspector.this.view.getType());
                    }
                    Property p = ObjectInspector.this.view.getProperty(ObjectInspector.this.properties[row - 2]);
                    if (p == null) {
                        return "<unknown>";
                    }
                    return p.getStringValue();
                }
                case 2: {
                    if (row == 0) {
                        return "";
                    }
                    if (row == 1) {
                        return "";
                    }
                    Property p = ObjectInspector.this.view.getProperty(ObjectInspector.this.properties[row - 2]);
                    if (p == null) {
                        return "<unknown>";
                    }
                    return "" + p.getLastUpdate();
                }
                case 3: {
                    if (row == 0) {
                        return "";
                    }
                    if (row == 1) {
                        return "";
                    }
                    Property p = ObjectInspector.this.view.getProperty(ObjectInspector.this.properties[row - 2]);
                    if (p == null) {
                        return "<unknown>";
                    }
                    Object result = p.getLastUpdateSource();
                    return result == null ? "null" : result.toString();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + col);
        }
    }
}

