/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.random;

import java.util.Random;
import org.uncommons.maths.binary.BinaryUtils;
import org.uncommons.maths.random.DefaultSeedGenerator;
import org.uncommons.maths.random.RepeatableRNG;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public class XORShiftRNG
extends Random
implements RepeatableRNG {
    private static final int SEED_SIZE_BYTES = 20;
    private final int[] state;
    private final byte[] seed;

    public XORShiftRNG() {
        this(DefaultSeedGenerator.getInstance().generateSeed(20));
    }

    public XORShiftRNG(SeedGenerator seedGenerator) throws SeedException {
        this(seedGenerator.generateSeed(20));
    }

    public XORShiftRNG(byte[] seed) {
        if (seed == null || seed.length != 20) {
            throw new IllegalArgumentException("XOR shift RNG requires 160 bits of seed data.");
        }
        this.seed = (byte[])seed.clone();
        this.state = BinaryUtils.convertBytesToInts(seed);
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    protected int next(int bits) {
        int t = this.state[0] ^ this.state[0] >> 7;
        this.state[0] = this.state[1];
        this.state[1] = this.state[2];
        this.state[2] = this.state[3];
        this.state[3] = this.state[4];
        this.state[4] = this.state[4] ^ this.state[4] << 6 ^ (t ^ t << 13);
        int value = (this.state[1] + this.state[1] + 1) * this.state[4];
        return value >>> 32 - bits;
    }
}

