/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.legacy2gml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import maps.convert.legacy2gml.BuildingInfo;
import maps.convert.legacy2gml.RoadInfo;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLRoad;
import maps.legacy.LegacyBuilding;
import maps.legacy.LegacyMap;
import maps.legacy.LegacyNode;
import maps.legacy.LegacyObject;
import maps.legacy.LegacyRoad;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;

public class NodeInfo {
    private LegacyNode node;
    private Point2D centre;
    private List<GMLNode> apexes;
    private GMLRoad road;

    public NodeInfo(LegacyNode node) {
        this.node = node;
        this.centre = new Point2D((double)node.getX(), (double)node.getY());
    }

    public LegacyNode getNode() {
        return this.node;
    }

    public Point2D getLocation() {
        return this.centre;
    }

    public GMLRoad getRoad() {
        return this.road;
    }

    public void process(LegacyMap legacy, GMLMap gml, Map<Integer, RoadInfo> roadInfo, Map<Integer, BuildingInfo> buildingInfo) {
        this.apexes = new ArrayList<GMLNode>();
        ArrayList<EdgeAspect> edges = new ArrayList<EdgeAspect>();
        for (int id : this.node.getEdges()) {
            LegacyRoad lRoad = legacy.getRoad(id);
            if (lRoad != null && roadInfo.containsKey(id)) {
                edges.add(new RoadAspect(lRoad, this.node, legacy, roadInfo.get(id)));
                continue;
            }
            LegacyBuilding lBuilding = legacy.getBuilding(id);
            if (lBuilding == null || !buildingInfo.containsKey(id)) continue;
            edges.add(new BuildingAspect(lBuilding, this.node, legacy, buildingInfo.get(id)));
        }
        if (edges.size() == 1) {
            EdgeAspect aspect = (EdgeAspect)edges.get(0);
            this.findRoadEdges(aspect, this.centre);
        } else {
            Point2D[] newApexes;
            EdgeAspect first;
            CounterClockwiseSort sort = new CounterClockwiseSort(this.centre);
            Collections.sort(edges, sort);
            Iterator it = edges.iterator();
            EdgeAspect prev = first = (EdgeAspect)it.next();
            while (it.hasNext()) {
                EdgeAspect next = (EdgeAspect)it.next();
                for (Point2D apex : newApexes = this.findIncomingEdgeIntersection(prev, next, this.centre)) {
                    this.apexes.add(gml.createNode(apex.getX(), apex.getY()));
                }
                prev = next;
            }
            for (Point2D apex : newApexes = this.findIncomingEdgeIntersection(prev, first, this.centre)) {
                this.apexes.add(gml.createNode(apex.getX(), apex.getY()));
            }
        }
        if (this.apexes.size() > 2) {
            this.road = gml.createRoadFromNodes(this.apexes);
        }
    }

    private Point2D[] findIncomingEdgeIntersection(EdgeAspect first, EdgeAspect second, Point2D centrePoint) {
        Point2D start2Point;
        Line2D line2;
        LegacyObject firstNode = first.getFarNode();
        LegacyObject secondNode = second.getFarNode();
        Point2D firstPoint = new Point2D((double)firstNode.getX(), (double)firstNode.getY());
        Point2D secondPoint = new Point2D((double)secondNode.getX(), (double)secondNode.getY());
        Vector2D firstVector = centrePoint.minus(firstPoint);
        Vector2D secondVector = centrePoint.minus(secondPoint);
        Vector2D firstNormal = firstVector.getNormal().normalised().scale((double)(-first.getRoadWidth()) / 2.0);
        Vector2D secondNormal = secondVector.getNormal().normalised().scale((double)second.getRoadWidth() / 2.0);
        Point2D start1Point = firstPoint.plus(firstNormal);
        Line2D line1 = new Line2D(start1Point, firstVector);
        Point2D intersection = GeometryTools2D.getIntersectionPoint((Line2D)line1, (Line2D)(line2 = new Line2D(start2Point = secondPoint.plus(secondNormal), secondVector)));
        if (intersection == null) {
            intersection = centrePoint.plus(firstNormal);
        }
        double maxWidth = Math.max(first.getRoadWidth(), second.getRoadWidth());
        double distance = GeometryTools2D.getDistance((Point2D)centrePoint, (Point2D)intersection);
        Vector2D intersectionVector = intersection.minus(centrePoint).normalised();
        double dp1 = firstVector.normalised().dot(intersectionVector);
        double dp2 = secondVector.normalised().dot(intersectionVector);
        if (distance > maxWidth && dp1 > 0.0 && dp2 > 0.0) {
            Vector2D cutoffVector = intersectionVector.getNormal().scale(maxWidth);
            Point2D cutoffStart = centrePoint.plus(intersectionVector.scale(maxWidth)).plus(cutoffVector);
            Line2D cutoffLine = new Line2D(cutoffStart, cutoffVector.scale(-2.0));
            Point2D end1 = GeometryTools2D.getIntersectionPoint((Line2D)line1, (Line2D)cutoffLine);
            Point2D end2 = GeometryTools2D.getIntersectionPoint((Line2D)line2, (Line2D)cutoffLine);
            first.setRightEnd(end1);
            second.setLeftEnd(end2);
            return new Point2D[]{end1, end2};
        }
        if (distance > maxWidth && (dp1 > 0.0 || dp2 > 0.0)) {
            double avgWidth = (double)(first.getRoadWidth() + second.getRoadWidth()) / 2.0;
            firstNormal = firstVector.getNormal().normalised().scale(-avgWidth / 2.0);
            secondNormal = secondVector.getNormal().normalised().scale(avgWidth / 2.0);
            start1Point = firstPoint.plus(firstNormal);
            start2Point = secondPoint.plus(secondNormal);
            line1 = new Line2D(start1Point, firstVector);
            line2 = new Line2D(start2Point, secondVector);
            intersection = GeometryTools2D.getIntersectionPoint((Line2D)line1, (Line2D)line2);
            first.setRightEnd(intersection);
            second.setLeftEnd(intersection);
        } else if (distance > maxWidth) {
            intersection = centrePoint.plus(intersectionVector.scale(maxWidth * 2.0));
            first.setRightEnd(intersection);
            second.setLeftEnd(intersection);
        } else {
            first.setRightEnd(intersection);
            second.setLeftEnd(intersection);
        }
        return new Point2D[]{intersection};
    }

    private void findRoadEdges(EdgeAspect aspect, Point2D centrePoint) {
        LegacyObject farNode = aspect.getFarNode();
        Point2D roadPoint = new Point2D((double)farNode.getX(), (double)farNode.getY());
        Vector2D vector = centrePoint.minus(roadPoint);
        Vector2D leftNormal = vector.getNormal().normalised().scale((double)aspect.getRoadWidth() / 2.0);
        Vector2D rightNormal = leftNormal.scale(-1.0);
        Point2D left = centrePoint.plus(leftNormal);
        Point2D right = centrePoint.plus(rightNormal);
        aspect.setLeftEnd(left);
        aspect.setRightEnd(right);
    }

    private static class CounterClockwiseSort
    implements Comparator<EdgeAspect> {
        private Point2D centre;

        public CounterClockwiseSort(Point2D centre) {
            this.centre = centre;
        }

        @Override
        public int compare(EdgeAspect first, EdgeAspect second) {
            double d2;
            double d1 = this.score(first);
            if (d1 < (d2 = this.score(second))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        public double score(EdgeAspect aspect) {
            LegacyObject node = aspect.getFarNode();
            Point2D point = new Point2D((double)node.getX(), (double)node.getY());
            Vector2D v = point.minus(this.centre);
            double sin = v.getX() / v.getLength();
            double cos = v.getY() / v.getLength();
            if (Double.isNaN(sin) || Double.isNaN(cos)) {
                System.out.println(v);
                System.out.println(v.getLength());
            }
            return this.convert(sin, cos);
        }

        private double convert(double sin, double cos) {
            if (sin >= 0.0 && cos >= 0.0) {
                return sin;
            }
            if (sin >= 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos >= 0.0) {
                return 4.0 + sin;
            }
            throw new IllegalArgumentException("This should be impossible! What's going on? sin=" + sin + ", cos=" + cos);
        }
    }

    private static class BuildingAspect
    implements EdgeAspect {
        private LegacyBuilding building;
        private BuildingInfo info;

        BuildingAspect(LegacyBuilding building, LegacyNode intersection, LegacyMap map, BuildingInfo info) {
            this.building = building;
            this.info = info;
        }

        @Override
        public int getRoadWidth() {
            return 3000;
        }

        @Override
        public LegacyObject getFarNode() {
            return this.building;
        }

        @Override
        public void setLeftEnd(Point2D p) {
            this.info.setRoadLeft(p);
        }

        @Override
        public void setRightEnd(Point2D p) {
            this.info.setRoadRight(p);
        }
    }

    private static class RoadAspect
    implements EdgeAspect {
        private boolean forward;
        private LegacyNode farNode;
        private RoadInfo info;
        private int width;

        RoadAspect(LegacyRoad road, LegacyNode intersection, LegacyMap map, RoadInfo info) {
            this.forward = intersection.getID() == road.getTail();
            this.farNode = map.getNode(this.forward ? road.getHead() : road.getTail());
            this.width = road.getWidth();
            this.info = info;
        }

        @Override
        public int getRoadWidth() {
            return this.width;
        }

        @Override
        public LegacyObject getFarNode() {
            return this.farNode;
        }

        @Override
        public void setLeftEnd(Point2D p) {
            if (this.forward) {
                this.info.setHeadLeft(p);
            } else {
                this.info.setTailRight(p);
            }
        }

        @Override
        public void setRightEnd(Point2D p) {
            if (this.forward) {
                this.info.setHeadRight(p);
            } else {
                this.info.setTailLeft(p);
            }
        }
    }

    private static interface EdgeAspect {
        public int getRoadWidth();

        public LegacyObject getFarNode();

        public void setLeftEnd(Point2D var1);

        public void setRightEnd(Point2D var1);
    }
}

