/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.CleanOSMStep;
import maps.convert.osm2gml.ComputePassableEdgesStep;
import maps.convert.osm2gml.MakeObjectsStep;
import maps.convert.osm2gml.MakeTempObjectsStep;
import maps.convert.osm2gml.MergeShapesStep;
import maps.convert.osm2gml.RemoveShapesStep;
import maps.convert.osm2gml.ScanOSMStep;
import maps.convert.osm2gml.SplitIntersectingEdgesStep;
import maps.convert.osm2gml.SplitShapesStep;
import maps.convert.osm2gml.TemporaryMap;
import maps.gml.GMLMap;
import maps.osm.OSMMap;

public class Convertor {
    private static final int PROGRESS_WIDTH = 200;
    private static final int PROGRESS_HEIGHT = 10;
    private static final int STATUS_WIDTH = 500;
    private static final int STATUS_HEIGHT = 10;
    private static final int MARGIN = 4;

    public GMLMap convert(OSMMap map) {
        GMLMap gmlMap = new GMLMap();
        JFrame frame = new JFrame("OSM to GML converter");
        JPanel main = new JPanel(new BorderLayout());
        Box top = Box.createVerticalBox();
        top.add(new JLabel("Converting OSM map with " + map.getRoads().size() + " roads and " + map.getBuildings().size() + " buildings"));
        top.add(new JLabel("Map size: " + (map.getMaxLongitude() - map.getMinLongitude()) + " x " + (map.getMaxLatitude() - map.getMinLatitude())));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(4, 4, 4, 4);
        JPanel progress = new JPanel(layout);
        TemporaryMap temp = new TemporaryMap(map);
        ArrayList<ConvertStep> steps = new ArrayList<ConvertStep>();
        this.addStep(new CleanOSMStep(temp), steps, progress, layout, c);
        this.addStep(new ScanOSMStep(temp), steps, progress, layout, c);
        this.addStep(new MakeTempObjectsStep(temp), steps, progress, layout, c);
        this.addStep(new SplitIntersectingEdgesStep(temp), steps, progress, layout, c);
        this.addStep(new SplitShapesStep(temp), steps, progress, layout, c);
        this.addStep(new RemoveShapesStep(temp), steps, progress, layout, c);
        this.addStep(new MergeShapesStep(temp), steps, progress, layout, c);
        this.addStep(new ComputePassableEdgesStep(temp), steps, progress, layout, c);
        this.addStep(new MakeObjectsStep(temp, gmlMap), steps, progress, layout, c);
        main.add(top);
        main.add(progress);
        frame.setContentPane(main);
        frame.pack();
        frame.setVisible(true);
        for (ConvertStep next : steps) {
            next.doStep();
        }
        return gmlMap;
    }

    private void addStep(ConvertStep step, List<ConvertStep> steps, JComponent panel, GridBagLayout layout, GridBagConstraints c) {
        JLabel title = new JLabel(step.getDescription());
        JProgressBar progress = step.getProgressBar();
        JComponent status = step.getStatusComponent();
        c.gridx = 0;
        c.weightx = 1.0;
        layout.setConstraints(title, c);
        panel.add(title);
        c.gridx = 1;
        c.weightx = 0.0;
        layout.setConstraints(progress, c);
        panel.add(progress);
        c.gridx = 2;
        c.weightx = 1.0;
        layout.setConstraints(status, c);
        panel.add(status);
        ++c.gridy;
        progress.setPreferredSize(new Dimension(200, 10));
        status.setPreferredSize(new Dimension(500, 10));
        steps.add(step);
    }
}

