/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maps.ScaleConversion;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryRoad;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLShape;

public class MakeObjectsStep
extends ConvertStep {
    private TemporaryMap map;
    private GMLMap gmlMap;

    public MakeObjectsStep(TemporaryMap map, GMLMap gmlMap) {
        this.map = map;
        this.gmlMap = gmlMap;
    }

    @Override
    public String getDescription() {
        return "Generating GML objects";
    }

    @Override
    protected void step() {
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        for (Node next : this.map.getAllNodes()) {
            xMin = Math.min(xMin, next.getX());
            yMin = Math.min(yMin, next.getY());
        }
        double sizeOf1m = ConvertTools.sizeOf1Metre(this.map.getOSMMap());
        double scale = 1.0 / sizeOf1m;
        ScaleConversion conversion = new ScaleConversion(xMin, yMin, scale, scale);
        Collection<Node> nodes = this.map.getAllNodes();
        Collection<Edge> edges = this.map.getAllEdges();
        this.setProgressLimit(nodes.size() + edges.size() + this.map.getAllObjects().size() * 2);
        HashMap<Node, GMLNode> nodeMap = new HashMap<Node, GMLNode>();
        HashMap<Edge, GMLEdge> edgeMap = new HashMap<Edge, GMLEdge>();
        HashMap<TemporaryObject, GMLShape> shapeMap = new HashMap<TemporaryObject, GMLShape>();
        for (Node n : nodes) {
            GMLNode node = this.gmlMap.createNode(conversion.convertX(n.getX()), conversion.convertY(n.getY()));
            nodeMap.put(n, node);
            this.bumpProgress();
        }
        for (Edge e : edges) {
            GMLNode first = (GMLNode)nodeMap.get(e.getStart());
            GMLNode second = (GMLNode)nodeMap.get(e.getEnd());
            GMLEdge edge = this.gmlMap.createEdge(first, second);
            edgeMap.put(e, edge);
            this.bumpProgress();
        }
        for (TemporaryBuilding b : this.map.getBuildings()) {
            shapeMap.put(b, this.gmlMap.createBuilding(this.makeEdges(b, edgeMap)));
            this.bumpProgress();
        }
        for (TemporaryRoad r : this.map.getRoads()) {
            shapeMap.put(r, this.gmlMap.createRoad(this.makeEdges(r, edgeMap)));
            this.bumpProgress();
        }
        for (TemporaryIntersection i : this.map.getIntersections()) {
            shapeMap.put(i, this.gmlMap.createRoad(this.makeEdges(i, edgeMap)));
            this.bumpProgress();
        }
        for (TemporaryObject o : this.map.getAllObjects()) {
            GMLShape s = (GMLShape)shapeMap.get(o);
            for (DirectedEdge e : o.getEdges()) {
                TemporaryObject neighbour = o.getNeighbour(e);
                if (neighbour == null) continue;
                s.setNeighbour((GMLEdge)edgeMap.get(e.getEdge()), (Integer)((GMLShape)shapeMap.get(neighbour)).getID());
            }
            this.bumpProgress();
        }
        this.setStatus("Created " + this.gmlMap.getRoads().size() + " roads and " + this.gmlMap.getBuildings().size() + " buildings");
    }

    private List<GMLDirectedEdge> makeEdges(TemporaryObject o, Map<Edge, GMLEdge> edgeMap) {
        List<DirectedEdge> oldEdges = o.getEdges();
        ArrayList<GMLDirectedEdge> result = new ArrayList<GMLDirectedEdge>(oldEdges.size());
        for (DirectedEdge dEdge : oldEdges) {
            result.add(new GMLDirectedEdge(edgeMap.get(dEdge.getEdge()), dEdge.isForward()));
        }
        return result;
    }
}

