/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.TemporaryMap;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class SplitIntersectingEdgesStep
extends ConvertStep {
    private TemporaryMap map;
    private int splitCount;
    private int inspectedCount;
    private Deque<Edge> toCheck;
    private Set<Edge> seen;

    public SplitIntersectingEdgesStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Splitting intersecting edges";
    }

    @Override
    protected void step() {
        this.debug.setBackground(ConvertTools.getAllDebugShapes(this.map));
        this.toCheck = new ArrayDeque<Edge>(this.map.getAllEdges());
        this.seen = new HashSet<Edge>();
        this.setProgressLimit(this.toCheck.size());
        this.splitCount = 0;
        this.inspectedCount = 0;
        while (!this.toCheck.isEmpty()) {
            Edge next = this.toCheck.pop();
            this.check(next);
            ++this.inspectedCount;
            this.setProgressLimit(this.toCheck.size() + this.inspectedCount);
            this.bumpProgress();
        }
        this.setStatus("Inspected " + this.inspectedCount + " edges and split " + this.splitCount);
    }

    private void check(Edge e) {
        Line2D l2;
        Edge test;
        if (!this.map.getAllEdges().contains(e)) {
            return;
        }
        if (this.seen.contains(e)) {
            return;
        }
        this.seen.add(e);
        Line2D l1 = e.getLine();
        HashSet<Edge> edges = new HashSet<Edge>(this.map.getAllEdges());
        Iterator i$ = edges.iterator();
        while (i$.hasNext() && ((test = (Edge)i$.next()).equals(e) || !(GeometryTools2D.parallel((Line2D)l1, (Line2D)(l2 = test.getLine())) ? this.processParallelLines(e, test) : this.checkForIntersection(e, test)))) {
        }
    }

    private boolean processParallelLines(Edge e1, Edge e2) {
        boolean endInside;
        Edge shorterEdge = e1;
        Edge longerEdge = e2;
        if (e1.getLine().getDirection().getLength() > e2.getLine().getDirection().getLength()) {
            shorterEdge = e2;
            longerEdge = e1;
        }
        Line2D shorter = shorterEdge.getLine();
        Line2D longer = longerEdge.getLine();
        boolean shortStartLongStart = shorterEdge.getStart() == longerEdge.getStart();
        boolean shortStartLongEnd = shorterEdge.getStart() == longerEdge.getEnd();
        boolean shortEndLongStart = shorterEdge.getEnd() == longerEdge.getStart();
        boolean shortEndLongEnd = shorterEdge.getEnd() == longerEdge.getEnd();
        boolean startInside = !shortStartLongStart && !shortStartLongEnd && GeometryTools2D.contains((Line2D)longer, (Point2D)shorter.getOrigin());
        boolean bl = endInside = !shortEndLongStart && !shortEndLongEnd && GeometryTools2D.contains((Line2D)longer, (Point2D)shorter.getEndPoint());
        if (startInside && endInside) {
            this.processInternalEdge(shorterEdge, longerEdge);
            return longerEdge == e1;
        }
        if (startInside && !endInside) {
            if (shortEndLongStart) {
                this.processCoincidentNode(shorterEdge, longerEdge, shorterEdge.getEnd());
                return longerEdge == e1;
            }
            if (shortEndLongEnd) {
                this.processCoincidentNode(shorterEdge, longerEdge, shorterEdge.getEnd());
                return longerEdge == e1;
            }
            this.processOverlap(shorterEdge, longerEdge);
            return true;
        }
        if (endInside && !startInside) {
            if (shortStartLongStart) {
                this.processCoincidentNode(shorterEdge, longerEdge, shorterEdge.getStart());
                return longerEdge == e1;
            }
            if (shortStartLongEnd) {
                this.processCoincidentNode(shorterEdge, longerEdge, shorterEdge.getStart());
                return longerEdge == e1;
            }
            this.processOverlap(shorterEdge, longerEdge);
            return true;
        }
        return false;
    }

    private boolean checkForIntersection(Edge first, Edge second) {
        List<Edge> e;
        Node n;
        Point2D intersection = GeometryTools2D.getSegmentIntersectionPoint((Line2D)first.getLine(), (Line2D)second.getLine());
        if (intersection == null) {
            double d;
            intersection = GeometryTools2D.getIntersectionPoint((Line2D)first.getLine(), (Line2D)second.getLine());
            if (this.map.isNear(intersection, first.getStart().getCoordinates()) || this.map.isNear(intersection, first.getEnd().getCoordinates())) {
                d = second.getLine().getIntersection(first.getLine());
                if (d < 0.0 || d > 1.0) {
                    return false;
                }
            } else if (this.map.isNear(intersection, second.getStart().getCoordinates()) || this.map.isNear(intersection, second.getEnd().getCoordinates())) {
                d = first.getLine().getIntersection(second.getLine());
                if (d < 0.0 || d > 1.0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        boolean splitFirst = !(n = this.map.getNode(intersection)).equals(first.getStart()) && !n.equals(first.getEnd());
        boolean splitSecond = !n.equals(second.getStart()) && !n.equals(second.getEnd());
        HashSet<Edge> newEdges = new HashSet<Edge>();
        if (splitFirst) {
            e = this.map.splitEdge(first, n);
            this.toCheck.addAll(e);
            newEdges.addAll(e);
            ++this.splitCount;
        }
        if (splitSecond) {
            e = this.map.splitEdge(second, n);
            this.toCheck.addAll(e);
            newEdges.addAll(e);
            ++this.splitCount;
        }
        return splitFirst;
    }

    private void processInternalEdge(Edge shorter, Edge longer) {
        Node second;
        Node first;
        double t2;
        double t1 = GeometryTools2D.positionOnLine((Line2D)longer.getLine(), (Point2D)shorter.getLine().getOrigin());
        if (t1 < (t2 = GeometryTools2D.positionOnLine((Line2D)longer.getLine(), (Point2D)shorter.getLine().getEndPoint()))) {
            first = shorter.getStart();
            second = shorter.getEnd();
        } else {
            first = shorter.getEnd();
            second = shorter.getStart();
        }
        this.toCheck.addAll(this.map.splitEdge(longer, first, second));
        ++this.splitCount;
    }

    private void processCoincidentNode(Edge shorter, Edge longer, Node coincidentPoint) {
        Node cutPoint = coincidentPoint.equals(shorter.getStart()) ? shorter.getEnd() : shorter.getStart();
        this.toCheck.addAll(this.map.splitEdge(longer, cutPoint));
        ++this.splitCount;
    }

    private void processOverlap(Edge shorter, Edge longer) {
        Node shortSplit = GeometryTools2D.contains((Line2D)shorter.getLine(), (Point2D)longer.getLine().getOrigin()) ? longer.getStart() : longer.getEnd();
        Node longSplit = GeometryTools2D.contains((Line2D)longer.getLine(), (Point2D)shorter.getLine().getOrigin()) ? shorter.getStart() : shorter.getEnd();
        this.toCheck.addAll(this.map.splitEdge(shorter, shortSplit));
        this.toCheck.addAll(this.map.splitEdge(longer, longSplit));
        ++this.splitCount;
    }
}

