/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class GMLCoordinates {
    private static final NumberFormat FORMAT = new DecimalFormat("#0.000", DecimalFormatSymbols.getInstance(Locale.US));
    private double x;
    private double y;

    public GMLCoordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public GMLCoordinates(GMLCoordinates other) {
        this.x = other.x;
        this.y = other.y;
    }

    public GMLCoordinates(String s) {
        int index = s.indexOf(",");
        if (index == -1) {
            throw new IllegalArgumentException("'" + s + "' is not of the form 'x,y'");
        }
        try {
            this.x = Double.parseDouble(s.substring(0, index));
            this.y = Double.parseDouble(s.substring(index + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + s + "' is not of the form 'x,y'", e);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double newX) {
        this.x = newX;
    }

    public void setY(double newY) {
        this.y = newY;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(FORMAT.format(this.x));
        result.append(",");
        result.append(FORMAT.format(this.y));
        return result.toString();
    }
}

