/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;

public abstract class CreateShapeTool
extends AbstractTool {
    private static final Color HOVER_COLOUR = Color.BLUE;
    private static final Color SELECTED_COLOUR = Color.GREEN;
    private static final Color POSSIBLE_COLOUR = Color.WHITE;
    private Listener listener = new Listener();
    private EdgeDecorator hoverHighlight = new LineEdgeDecorator(HOVER_COLOUR);
    private EdgeDecorator selectedHighlight = new LineEdgeDecorator(SELECTED_COLOUR);
    private EdgeDecorator possibleHighlight = new LineEdgeDecorator(POSSIBLE_COLOUR);
    private List<GMLEdge> edges = new ArrayList<GMLEdge>();
    private List<GMLNode> nodes = new ArrayList<GMLNode>();
    private Set<GMLEdge> possible = new HashSet<GMLEdge>();
    private GMLNode startNode;
    private GMLNode currentNode;
    private GMLEdge hover;

    protected CreateShapeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.clearData();
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
        this.clearData();
    }

    protected abstract UndoableEdit finished(List<GMLNode> var1);

    private void addEdge(GMLEdge edge) {
        this.editor.getViewer().clearEdgeDecorator(this.possible);
        this.edges.add(edge);
        this.possible.clear();
        this.editor.getViewer().setEdgeDecorator(this.selectedHighlight, edge);
        this.editor.getViewer().repaint();
        if (this.edges.size() == 1) {
            this.startNode = edge.getStart();
            this.currentNode = edge.getEnd();
            this.possible.addAll(this.editor.getMap().getAttachedEdges(this.startNode));
            this.possible.addAll(this.editor.getMap().getAttachedEdges(this.currentNode));
        } else if (this.edges.size() == 2) {
            GMLNode shared;
            GMLEdge first = this.edges.get(0);
            GMLEdge second = this.edges.get(1);
            if (first.getStart().equals(second.getStart()) || first.getStart().equals(second.getEnd())) {
                this.startNode = first.getEnd();
                shared = first.getStart();
            } else {
                this.startNode = first.getStart();
                shared = first.getEnd();
            }
            this.currentNode = shared.equals(second.getStart()) ? second.getEnd() : second.getStart();
            this.nodes.add(this.startNode);
            this.nodes.add(shared);
            this.nodes.add(this.currentNode);
            this.possible.addAll(this.editor.getMap().getAttachedEdges(this.currentNode));
        } else if (this.edges.size() > 2) {
            GMLNode gMLNode = this.currentNode = this.currentNode.equals(edge.getStart()) ? edge.getEnd() : edge.getStart();
            if (this.currentNode.equals(this.startNode)) {
                this.editor.addEdit(this.finished(this.nodes));
                this.editor.setChanged();
                this.clearData();
                this.editor.getViewer().clearAllEdgeDecorators();
                this.editor.getViewer().repaint();
            } else {
                this.nodes.add(this.currentNode);
                this.possible.addAll(this.editor.getMap().getAttachedEdges(this.currentNode));
            }
        }
        this.possible.removeAll(this.edges);
        this.editor.getViewer().setEdgeDecorator(this.possibleHighlight, this.possible);
        if (this.possible.size() == 1) {
            this.addEdge(this.possible.iterator().next());
        }
        this.editor.getViewer().repaint();
    }

    private void clearData() {
        this.nodes.clear();
        this.edges.clear();
        this.possible.clear();
        this.startNode = null;
        this.currentNode = null;
        this.hover = null;
    }

    private void hover(GMLEdge edge) {
        if (this.hover == edge) {
            return;
        }
        if (this.hover != null) {
            this.editor.getViewer().clearEdgeDecorator(this.hover);
            if (this.possible.contains(this.hover)) {
                this.editor.getViewer().setEdgeDecorator(this.possibleHighlight, this.hover);
            }
        }
        this.hover = edge;
        if (this.hover != null) {
            this.editor.getViewer().setEdgeDecorator(this.hoverHighlight, this.hover);
        }
        this.editor.getViewer().repaint();
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = CreateShapeTool.this.editor.snap(CreateShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            if (CreateShapeTool.this.edges.isEmpty()) {
                CreateShapeTool.this.hover(CreateShapeTool.this.editor.getMap().findNearestEdge(c.getX(), c.getY()));
            } else {
                CreateShapeTool.this.hover(CreateShapeTool.this.editor.getMap().findNearestEdge(c.getX(), c.getY(), CreateShapeTool.this.possible));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CreateShapeTool.this.hover != null && e.getButton() == 1) {
                GMLEdge edge = CreateShapeTool.this.hover;
                CreateShapeTool.this.hover(null);
                CreateShapeTool.this.addEdge(edge);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = CreateShapeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

