/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import maps.gml.GMLNode;
import maps.gml.GMLSpace;
import maps.gml.editor.CreateShapeTool;
import maps.gml.editor.GMLEditor;

public class CreateSpaceTool
extends CreateShapeTool {
    public CreateSpaceTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Create space";
    }

    @Override
    protected UndoableEdit finished(List<GMLNode> nodes) {
        GMLSpace space = this.editor.getMap().createSpaceFromNodes(nodes);
        return new CreateSpaceEdit(space);
    }

    private class CreateSpaceEdit
    extends AbstractUndoableEdit {
        private GMLSpace space;

        public CreateSpaceEdit(GMLSpace space) {
            this.space = space;
        }

        @Override
        public void undo() {
            super.undo();
            CreateSpaceTool.this.editor.getMap().removeSpace(this.space);
            CreateSpaceTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            CreateSpaceTool.this.editor.getMap().addSpace(this.space);
            CreateSpaceTool.this.editor.getViewer().repaint();
        }
    }
}

