/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;
import maps.gml.view.SquareNodeDecorator;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class InspectTool
extends AbstractTool {
    private static final int NEARBY = 5;
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private static final int NODE_SIZE = 5;
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 5);
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private FilledShapeDecorator shapeHighlight = new FilledShapeDecorator(HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR);

    public InspectTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Inspect object";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().clearAllBuildingDecorators();
        this.editor.getViewer().clearAllRoadDecorators();
        this.editor.getViewer().clearAllSpaceDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlight(GMLObject object) {
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().clearAllBuildingDecorators();
        this.editor.getViewer().clearAllRoadDecorators();
        this.editor.getViewer().clearAllSpaceDecorators();
        if (object instanceof GMLNode) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, (GMLNode)object);
        }
        if (object instanceof GMLEdge) {
            this.editor.getViewer().setEdgeDecorator(this.edgeHighlight, (GMLEdge)object);
        }
        if (object instanceof GMLBuilding) {
            this.editor.getViewer().setBuildingDecorator((BuildingDecorator)this.shapeHighlight, (GMLBuilding)object);
        }
        if (object instanceof GMLRoad) {
            this.editor.getViewer().setRoadDecorator((RoadDecorator)this.shapeHighlight, (GMLRoad)object);
        }
        if (object instanceof GMLSpace) {
            this.editor.getViewer().setSpaceDecorator((SpaceDecorator)this.shapeHighlight, (GMLSpace)object);
        }
        this.editor.getViewer().repaint();
    }

    private boolean closeEnough(GMLNode node, Point p) {
        GMLCoordinates lowerLeft = this.editor.getViewer().getCoordinatesAtPoint(p.x - 5, p.y + 5);
        GMLCoordinates topRight = this.editor.getViewer().getCoordinatesAtPoint(p.x + 5, p.y - 5);
        return node.getX() > lowerLeft.getX() && node.getX() < topRight.getX() && node.getY() > lowerLeft.getY() && node.getY() < topRight.getY();
    }

    private boolean closeEnough(GMLEdge edge, Point p) {
        Point start = this.editor.getViewer().getScreenCoordinates(edge.getStart().getCoordinates());
        Point end = this.editor.getViewer().getScreenCoordinates(edge.getEnd().getCoordinates());
        Point2D testPoint = new Point2D((double)p.x, (double)p.y);
        Point2D startPoint = new Point2D((double)start.x, (double)start.y);
        Point2D endPoint = new Point2D((double)end.x, (double)end.y);
        Line2D line = new Line2D(startPoint, endPoint);
        Point2D closest = GeometryTools2D.getClosestPointOnSegment((Line2D)line, (Point2D)testPoint);
        return GeometryTools2D.getDistance((Point2D)testPoint, (Point2D)closest) < 5.0;
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                InspectTool.this.editor.getInspector().inspect(this.findNearbyObject(p));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            InspectTool.this.highlight(this.findNearbyObject(p));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private GMLObject findNearbyObject(Point p) {
            GMLCoordinates c = InspectTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = InspectTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            GMLEdge edge = InspectTool.this.editor.getMap().findNearestEdge(c.getX(), c.getY());
            GMLShape shape = InspectTool.this.editor.getMap().findShapeUnder(c.getX(), c.getY());
            if (node != null && InspectTool.this.closeEnough(node, p)) {
                return node;
            }
            if (edge != null && InspectTool.this.closeEnough(edge, p)) {
                return edge;
            }
            return shape;
        }

        private Point fixEventPoint(Point p) {
            Insets insets = InspectTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

