/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;

public class MoveNodeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLACK;
    private static final int HIGHLIGHT_SIZE = 6;
    private Listener listener = new Listener();
    private NodeDecorator highlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 6);
    private GMLNode selected = null;
    private GMLCoordinates pressCoords;
    private GMLCoordinates originalCoords;

    public MoveNodeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Move node";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.selected = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlightNode(GMLNode node) {
        if (this.selected == node) {
            return;
        }
        if (this.selected != null) {
            this.editor.getViewer().clearNodeDecorator(this.selected);
        }
        this.selected = node;
        if (this.selected != null) {
            this.editor.getViewer().setNodeDecorator(this.highlight, this.selected);
        }
        this.editor.getViewer().repaint();
    }

    private class MoveNodeEdit
    extends AbstractUndoableEdit {
        private GMLNode node;
        private GMLCoordinates oldPosition;
        private GMLCoordinates newPosition;

        public MoveNodeEdit(GMLNode node, GMLCoordinates oldPosition, GMLCoordinates newPosition) {
            this.node = node;
            this.oldPosition = oldPosition;
            this.newPosition = newPosition;
        }

        @Override
        public void undo() {
            super.undo();
            this.node.setCoordinates(this.oldPosition);
            MoveNodeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            this.node.setCoordinates(this.newPosition);
            MoveNodeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = MoveNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = MoveNodeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            MoveNodeTool.this.highlightNode(node);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MoveNodeTool.this.selected == null) {
                return;
            }
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                MoveNodeTool.this.pressCoords = MoveNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                MoveNodeTool.this.originalCoords = new GMLCoordinates(MoveNodeTool.this.selected.getCoordinates());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MoveNodeTool.this.pressCoords = null;
            MoveNodeTool.this.editor.addEdit(new MoveNodeEdit(MoveNodeTool.this.selected, MoveNodeTool.this.originalCoords, new GMLCoordinates(MoveNodeTool.this.selected.getCoordinates())));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MoveNodeTool.this.selected == null) {
                return;
            }
            if (MoveNodeTool.this.pressCoords == null) {
                return;
            }
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates dragCoords = MoveNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            double dx = dragCoords.getX() - MoveNodeTool.this.pressCoords.getX();
            double dy = dragCoords.getY() - MoveNodeTool.this.pressCoords.getY();
            GMLCoordinates result = new GMLCoordinates(MoveNodeTool.this.originalCoords.getX() + dx, MoveNodeTool.this.originalCoords.getY() + dy);
            MoveNodeTool.this.editor.snap(result);
            MoveNodeTool.this.selected.setCoordinates(result);
            MoveNodeTool.this.editor.setChanged();
            MoveNodeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = MoveNodeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

