/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.LineOverlay;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;

public class SplitShapeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private static final int HIGHLIGHT_SIZE = 6;
    private static final double THRESHOLD = 0.001;
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 6);
    private LineOverlay overlay = new LineOverlay(HIGHLIGHT_COLOUR, true);
    private GMLNode hover;
    private GMLNode start;
    private GMLNode end;

    public SplitShapeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Split shape";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.editor.getViewer().addOverlay(this.overlay);
        this.hover = null;
        this.start = null;
        this.end = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().removeOverlay(this.overlay);
        this.editor.getViewer().repaint();
    }

    private void setHover(GMLNode node) {
        if (this.hover == node) {
            return;
        }
        if (this.hover != null) {
            this.editor.getViewer().clearNodeDecorator(this.hover);
        }
        this.hover = node;
        if (this.hover != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.hover);
        }
        this.editor.getViewer().repaint();
    }

    private void setStart(GMLNode node) {
        if (this.start == node) {
            return;
        }
        if (this.start != null) {
            this.editor.getViewer().clearNodeDecorator(this.start);
        }
        this.start = node;
        if (this.start != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.start);
        }
        this.editor.getViewer().repaint();
    }

    private void setEnd(GMLNode node) {
        if (this.start == node || this.end == node) {
            return;
        }
        if (this.end != null) {
            this.editor.getViewer().clearNodeDecorator(this.end);
        }
        this.end = node;
        if (this.end != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.end);
        }
        this.editor.getViewer().repaint();
    }

    private class SplitShapeEdit
    extends AbstractUndoableEdit {
        private Collection<GMLShape> add;
        private Collection<GMLShape> remove;
        private GMLEdge edge;

        public SplitShapeEdit(GMLEdge edge, Collection<GMLShape> add, Collection<GMLShape> remove) {
            this.edge = edge;
            this.add = add;
            this.remove = remove;
        }

        @Override
        public void undo() {
            super.undo();
            SplitShapeTool.this.editor.getMap().removeEdge(this.edge);
            SplitShapeTool.this.editor.getMap().remove(this.add);
            SplitShapeTool.this.editor.getMap().add(this.remove);
            SplitShapeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            SplitShapeTool.this.editor.getMap().addEdge(this.edge);
            for (GMLShape r : this.remove) {
                Logger.debug((String)("remove: " + r.toString()));
            }
            for (GMLShape r : this.add) {
                Logger.debug((String)("add: " + r.toString()));
            }
            SplitShapeTool.this.editor.getMap().remove(this.remove);
            SplitShapeTool.this.editor.getMap().add(this.add);
            SplitShapeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                GMLCoordinates c = SplitShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                GMLNode node = SplitShapeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
                SplitShapeTool.this.overlay.setStart(new Point2D(node.getX(), node.getY()));
                SplitShapeTool.this.setStart(node);
                SplitShapeTool.this.setHover(null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && SplitShapeTool.this.start != null && SplitShapeTool.this.end != null) {
                SplitShapeEdit edit = this.splitByEdge();
                SplitShapeTool.this.editor.setChanged();
                if (edit != null) {
                    SplitShapeTool.this.editor.addEdit(edit);
                }
                SplitShapeTool.this.editor.getViewer().clearAllNodeDecorators();
                SplitShapeTool.this.overlay.setStart(null);
                SplitShapeTool.this.overlay.setEnd(null);
                SplitShapeTool.this.editor.getViewer().repaint();
                SplitShapeTool.this.start = null;
                SplitShapeTool.this.end = null;
                SplitShapeTool.this.hover = null;
            }
        }

        private SplitShapeEdit splitByEdge() {
            ArrayList<GMLShape> add = new ArrayList<GMLShape>();
            ArrayList<GMLShape> delete = new ArrayList<GMLShape>();
            GMLEdge edge = SplitShapeTool.this.editor.getMap().createEdge(SplitShapeTool.this.start, SplitShapeTool.this.end);
            Collection<GMLEdge> startEdges = SplitShapeTool.this.editor.getMap().getAttachedEdges(SplitShapeTool.this.start);
            Collection<GMLEdge> endEdges = SplitShapeTool.this.editor.getMap().getAttachedEdges(SplitShapeTool.this.end);
            HashSet<GMLShape> startShapes = new HashSet<GMLShape>();
            HashSet<GMLShape> endShapes = new HashSet<GMLShape>();
            for (GMLEdge next : startEdges) {
                startShapes.addAll(SplitShapeTool.this.editor.getMap().getAttachedShapes(next));
            }
            for (GMLEdge next : endEdges) {
                endShapes.addAll(SplitShapeTool.this.editor.getMap().getAttachedShapes(next));
            }
            for (GMLShape shape : startShapes) {
                Pair<GMLShape, GMLShape> split;
                if (!endShapes.contains(shape) || (split = this.splitShape(shape, edge)) == null) continue;
                add.add((GMLShape)split.first());
                add.add((GMLShape)split.second());
                delete.add(shape);
            }
            if (!add.isEmpty()) {
                edge.setPassable(true);
                return new SplitShapeEdit(edge, add, delete);
            }
            SplitShapeTool.this.editor.getMap().remove((GMLObject)edge);
            return null;
        }

        private Pair<GMLShape, GMLShape> splitShape(GMLShape shape, GMLEdge edge) {
            double area2;
            ArrayList<GMLNode> nodes1 = new ArrayList<GMLNode>();
            ArrayList<GMLNode> nodes2 = new ArrayList<GMLNode>();
            boolean first = true;
            for (GMLNode n : shape.getUnderlyingNodes()) {
                if (n == edge.getStart() || n == edge.getEnd()) {
                    first = !first;
                    nodes1.add(n);
                    nodes2.add(n);
                    continue;
                }
                if (first) {
                    nodes1.add(n);
                    continue;
                }
                nodes2.add(n);
            }
            if (nodes1.size() <= 2 || nodes2.size() <= 2) {
                return null;
            }
            double oldArea = this.area(shape.getUnderlyingNodes());
            double area1 = this.area(nodes1);
            if (area1 + (area2 = this.area(nodes2)) > oldArea + 0.001) {
                return null;
            }
            GMLShape s1 = null;
            GMLShape s2 = null;
            if (shape instanceof GMLBuilding) {
                GMLBuilding b = (GMLBuilding)shape;
                GMLBuilding b1 = SplitShapeTool.this.editor.getMap().createBuildingFromNodes(nodes1);
                GMLBuilding b2 = SplitShapeTool.this.editor.getMap().createBuildingFromNodes(nodes2);
                b1.setCode(b.getCode());
                b2.setCode(b.getCode());
                b1.setFloors(b.getFloors());
                b2.setFloors(b.getFloors());
                b1.setImportance(b.getImportance());
                b2.setImportance(b.getImportance());
                s1 = b1;
                s2 = b2;
            } else if (shape instanceof GMLRoad) {
                s1 = SplitShapeTool.this.editor.getMap().createRoadFromNodes(nodes1);
                s2 = SplitShapeTool.this.editor.getMap().createRoadFromNodes(nodes2);
            } else if (shape instanceof GMLSpace) {
                s1 = SplitShapeTool.this.editor.getMap().createSpaceFromNodes(nodes1);
                s2 = SplitShapeTool.this.editor.getMap().createSpaceFromNodes(nodes2);
            } else {
                throw new IllegalArgumentException("Shape is not a building, road or space");
            }
            SplitShapeTool.this.editor.getMap().remove((GMLObject)shape);
            return new Pair((Object)s1, (Object)s2);
        }

        private double area(List<GMLNode> nodes) {
            ArrayList<Point2D> vertices = new ArrayList<Point2D>();
            for (GMLNode n : nodes) {
                vertices.add(new Point2D(n.getX(), n.getY()));
            }
            return GeometryTools2D.computeArea(vertices);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SplitShapeTool.this.start != null) {
                Point p = this.fixEventPoint(e.getPoint());
                GMLCoordinates c = SplitShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                GMLNode node = SplitShapeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
                SplitShapeTool.this.overlay.setEnd(new Point2D(node.getX(), node.getY()));
                SplitShapeTool.this.setEnd(node);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = SplitShapeTool.this.editor.snap(SplitShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            GMLNode node = SplitShapeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            SplitShapeTool.this.setHover(node);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = SplitShapeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

