/*
 * Decompiled with CFR 0.152.
 */
package maps.osm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import maps.osm.OSMMap;
import maps.osm.OSMMapViewer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class OSMMapExtractor
extends MouseAdapter {
    private static final int VIEWER_SIZE = 500;
    private static final Color DRAG_COLOUR = new Color(128, 128, 128, 64);
    private JComponent glass;
    private Point press;
    private Point drag;
    private Point release;
    private OSMMap map;
    private OSMMapViewer viewer;
    private Writer out;

    public OSMMapExtractor(OSMMap map, OSMMapViewer viewer, Writer out) {
        this.map = map;
        this.viewer = viewer;
        this.out = out;
        this.glass = new DragGlass();
    }

    public static void main(String[] args) {
        try {
            OSMMap map = new OSMMap(new File(args[0]));
            FileWriter out = new FileWriter(new File(args[1]));
            OSMMapViewer viewer = new OSMMapViewer(map);
            OSMMapExtractor extractor = new OSMMapExtractor(map, viewer, out);
            viewer.addMouseListener(extractor);
            viewer.setPreferredSize(new Dimension(500, 500));
            JFrame frame = new JFrame();
            frame.setGlassPane(extractor.getGlass());
            frame.setContentPane(viewer);
            frame.pack();
            frame.setVisible(true);
            frame.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JComponent getGlass() {
        return this.glass;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            Point p = e.getPoint();
            Insets insets = this.viewer.getInsets();
            p.translate(-insets.left, -insets.top);
            this.press = new Point(p);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getButton() == 3) {
            Point p = e.getPoint();
            Insets insets = this.viewer.getInsets();
            p.translate(-insets.left, -insets.top);
            this.drag = new Point(p);
            this.glass.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            Point p = e.getPoint();
            Insets insets = this.viewer.getInsets();
            p.translate(-insets.left, -insets.top);
            this.release = new Point(p);
            this.drag = null;
            this.write();
        }
    }

    private void write() {
        double pressLat = this.viewer.getLatitude(this.press.y);
        double pressLon = this.viewer.getLongitude(this.press.x);
        double releaseLat = this.viewer.getLatitude(this.release.y);
        double releaseLon = this.viewer.getLongitude(this.release.x);
        try {
            OSMMap newMap = new OSMMap(this.map, Math.min(pressLat, releaseLat), Math.min(pressLon, releaseLon), Math.max(pressLat, releaseLat), Math.max(pressLon, releaseLon));
            Document d = newMap.toXML();
            XMLWriter writer = new XMLWriter(this.out, OutputFormat.createPrettyPrint());
            writer.write(d);
            writer.flush();
            writer.close();
            System.out.println("Wrote map");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class DragGlass
    extends JComponent {
        private DragGlass() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (OSMMapExtractor.this.drag == null) {
                return;
            }
            g.setColor(DRAG_COLOUR);
            int x = Math.min(((OSMMapExtractor)OSMMapExtractor.this).press.x, ((OSMMapExtractor)OSMMapExtractor.this).drag.x);
            int y = Math.max(((OSMMapExtractor)OSMMapExtractor.this).press.y, ((OSMMapExtractor)OSMMapExtractor.this).drag.y);
            int width = Math.abs(((OSMMapExtractor)OSMMapExtractor.this).press.x - ((OSMMapExtractor)OSMMapExtractor.this).drag.x);
            int height = Math.abs(((OSMMapExtractor)OSMMapExtractor.this).press.y - ((OSMMapExtractor)OSMMapExtractor.this).drag.y);
            g.fillRect(x, y, width, height);
        }
    }
}

