/*
 * Decompiled with CFR 0.152.
 */
package maps.osm.debug;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import maps.osm.OSMWay;
import rescuecore2.misc.gui.DrawingTools;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.misc.gui.ShapeDebugFrame;

public class OSMWayShapeInfo
extends ShapeDebugFrame.ShapeInfo {
    private OSMWay way;
    private OSMMap map;
    private Color colour;
    private boolean drawEdgeDirections;
    private Rectangle2D bounds;

    public OSMWayShapeInfo(OSMWay way, OSMMap map, String name, Color colour, boolean drawEdgeDirections) {
        super((Object)way, name);
        this.way = way;
        this.map = map;
        this.colour = colour;
        this.drawEdgeDirections = drawEdgeDirections;
        if (way != null) {
            this.bounds = this.findBounds();
        }
    }

    public Shape paint(Graphics2D g, ScreenTransform transform) {
        if (this.way == null) {
            return null;
        }
        List<Long> points = this.way.getNodeIDs();
        int n = points.size();
        int[] xs = new int[n];
        int[] ys = new int[n];
        int i = 0;
        for (long next : points) {
            xs[i] = transform.xToScreen(this.map.getNode(next).getLongitude());
            ys[i] = transform.yToScreen(this.map.getNode(next).getLatitude());
            ++i;
        }
        Polygon p = new Polygon(xs, ys, n);
        if (this.colour != null) {
            g.setColor(this.colour);
            g.draw(p);
            if (this.drawEdgeDirections) {
                for (i = 1; i < n; ++i) {
                    DrawingTools.drawArrowHeads((int)xs[i - 1], (int)ys[i - 1], (int)xs[i], (int)ys[i], (Graphics)g);
                }
            }
        }
        return p;
    }

    public void paintLegend(Graphics2D g, int width, int height) {
        if (this.colour != null) {
            g.setColor(this.colour);
            g.drawRect(0, 0, width - 1, height - 1);
        }
    }

    public Rectangle2D getBoundsShape() {
        return this.bounds;
    }

    public Point2D getBoundsPoint() {
        return null;
    }

    private Rectangle2D findBounds() {
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (long next : this.way.getNodeIDs()) {
            OSMNode n = this.map.getNode(next);
            xMin = Math.min(xMin, n.getLongitude());
            xMax = Math.max(xMax, n.getLongitude());
            yMin = Math.min(yMin, n.getLatitude());
            yMax = Math.max(yMax, n.getLatitude());
        }
        return new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

