/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import rescuecore2.components.AbstractComponent;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.RequestIDGenerator;
import rescuecore2.components.Simulator;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.EntityIDRequest;
import rescuecore2.messages.control.EntityIDResponse;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.messages.control.KSConnectError;
import rescuecore2.messages.control.KSConnectOK;
import rescuecore2.messages.control.KSUpdate;
import rescuecore2.messages.control.SKAcknowledge;
import rescuecore2.messages.control.SKConnect;
import rescuecore2.messages.control.SKUpdate;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public abstract class AbstractSimulator<T extends WorldModel<? extends Entity>>
extends AbstractComponent<T>
implements Simulator {
    protected int simulatorID;
    private int lastUpdateTime;
    private Map<Integer, List<EntityID>> idRequests;
    private int nextIDRequest;

    protected AbstractSimulator() {
    }

    public final int getSimulatorID() {
        return this.simulatorID;
    }

    @Override
    public void postConnect(Connection c, int id, Collection<Entity> entities, Config kernelConfig) {
        this.simulatorID = id;
        this.lastUpdateTime = 0;
        this.nextIDRequest = 0;
        this.idRequests = new HashMap<Integer, List<EntityID>>();
        super.postConnect(c, entities, kernelConfig);
    }

    @Override
    public void connect(Connection connection, RequestIDGenerator generator, Config config) throws ConnectionException, ComponentConnectionException, InterruptedException {
        this.config = config;
        int requestID = generator.generateRequestID();
        SKConnect connect = new SKConnect(requestID, 1, this.getName());
        CountDownLatch latch = new CountDownLatch(1);
        SimulatorConnectionListener l = new SimulatorConnectionListener(requestID, latch);
        connection.addConnectionListener(l);
        connection.sendMessage(connect);
        latch.await();
        l.testSuccess();
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    protected void handleUpdate(KSUpdate u) {
        ChangeSet changes = u.getChangeSet();
        int time = u.getTime();
        if (time != this.lastUpdateTime + 1) {
            Logger.warn("Recieved an unexpected update from the kernel. Last update: " + this.lastUpdateTime + ", this update: " + time);
        }
        this.lastUpdateTime = time;
        this.model.merge(changes);
    }

    protected void handleCommands(KSCommands c) {
        ChangeSet changes = new ChangeSet();
        this.processCommands(c, changes);
        this.send(new SKUpdate(this.simulatorID, c.getTime(), changes));
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<EntityID> requestNewEntityIDs(int count) throws InterruptedException {
        Map<Integer, List<EntityID>> map = this.idRequests;
        synchronized (map) {
            int id = this.nextIDRequest++;
            Logger.debug("Requesting " + count + " new IDs: request number " + id);
            this.send(new EntityIDRequest(this.simulatorID, id, count));
            Integer key = id;
            while (!this.idRequests.containsKey(key)) {
                Logger.debug("Waiting for response");
                this.idRequests.wait();
            }
            List<EntityID> result = this.idRequests.get(key);
            this.idRequests.remove(key);
            return result;
        }
    }

    @Override
    protected void processMessage(Message msg) {
        if (msg instanceof KSUpdate) {
            KSUpdate u = (KSUpdate)msg;
            if (u.getTargetID() == this.simulatorID) {
                this.handleUpdate(u);
            }
        } else if (msg instanceof KSCommands) {
            KSCommands commands = (KSCommands)msg;
            if (commands.getTargetID() == this.simulatorID) {
                this.handleCommands(commands);
            }
        } else {
            super.processMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processImmediately(Message msg) {
        if (msg instanceof EntityIDResponse) {
            EntityIDResponse resp = (EntityIDResponse)msg;
            Logger.debug("Received " + msg);
            if (resp.getSimulatorID() == this.simulatorID) {
                Map<Integer, List<EntityID>> map = this.idRequests;
                synchronized (map) {
                    Logger.debug("ID response: " + resp.getRequestID() + ", " + resp.getEntityIDs());
                    this.idRequests.put(resp.getRequestID(), resp.getEntityIDs());
                    this.idRequests.notifyAll();
                }
            }
            return true;
        }
        return super.processImmediately(msg);
    }

    private class SimulatorConnectionListener
    implements ConnectionListener {
        private int requestID;
        private CountDownLatch latch;
        private ComponentConnectionException failureReason;

        public SimulatorConnectionListener(int requestID, CountDownLatch latch) {
            this.requestID = requestID;
            this.latch = latch;
            this.failureReason = null;
        }

        @Override
        public void messageReceived(Connection c, Message msg) {
            if (msg instanceof KSConnectOK) {
                this.handleConnectOK(c, (KSConnectOK)msg);
            }
            if (msg instanceof KSConnectError) {
                this.handleConnectError(c, (KSConnectError)msg);
            }
        }

        private void handleConnectOK(Connection c, KSConnectOK ok) {
            if (ok.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                AbstractSimulator.this.postConnect(c, ok.getSimulatorID(), ok.getEntities(), ok.getConfig());
                try {
                    c.sendMessage(new SKAcknowledge(this.requestID, ok.getSimulatorID()));
                }
                catch (ConnectionException e) {
                    this.failureReason = new ComponentConnectionException(e);
                }
                this.latch.countDown();
            }
        }

        private void handleConnectError(Connection c, KSConnectError error) {
            if (error.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                this.failureReason = new ComponentConnectionException(error.getReason());
                this.latch.countDown();
            }
        }

        void testSuccess() throws ComponentConnectionException {
            if (this.failureReason != null) {
                throw this.failureReason;
            }
        }
    }
}

