/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import rescuecore2.config.AbstractValueConstraint;
import rescuecore2.config.Config;

public class ClassNameValueConstraint
extends AbstractValueConstraint {
    private Class<?> required;

    public ClassNameValueConstraint(String key) {
        this(key, null);
    }

    public ClassNameValueConstraint(String key, Class<?> required) {
        super(key);
        this.required = required;
    }

    @Override
    public String getDescription() {
        if (this.required == null) {
            return "Must be a valid class name";
        }
        return "Must be a valid class name that extends " + this.required.getName();
    }

    @Override
    public boolean isValid(String value, Config config) {
        try {
            Class<?> c = Class.forName(value);
            if (this.required != null) {
                return this.required.isAssignableFrom(c);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

