/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import rescuecore2.connection.ConnectionManagerListener;
import rescuecore2.connection.TCPConnection;
import rescuecore2.log.Logger;
import rescuecore2.misc.WorkerThread;
import rescuecore2.registry.Registry;

public class ConnectionManager {
    private Set<Reader> readers;
    private boolean shutdown = false;
    private final Object lock = new Object();

    public ConnectionManager() {
        this.readers = new HashSet<Reader>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(int port, Registry registry, ConnectionManagerListener listener) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IOException("Connection manager has been shut down");
            }
            Logger.info("Listening for connections on port " + port);
            ServerSocket socket = new ServerSocket(port);
            socket.setSoTimeout(1000);
            socket.setReuseAddress(true);
            Reader r = new Reader(socket, registry, listener);
            this.readers.add(r);
            r.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        for (Reader next : this.readers) {
            try {
                next.kill();
            }
            catch (InterruptedException e) {
                Logger.error("ConnectionManager interrupted while shutting down read threads", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return !this.shutdown;
        }
    }

    private class Reader
    extends WorkerThread {
        private ServerSocket socket;
        private Registry registry;
        private ConnectionManagerListener callback;

        public Reader(ServerSocket socket, Registry registry, ConnectionManagerListener callback) {
            this.socket = socket;
            this.registry = registry;
            this.callback = callback;
        }

        @Override
        protected boolean work() {
            try {
                Socket s = this.socket.accept();
                TCPConnection conn = new TCPConnection(s);
                if (ConnectionManager.this.isAlive()) {
                    conn.setRegistry(this.registry);
                    this.callback.newConnection(conn);
                    conn.startup();
                }
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                Logger.error("Error listening for connection", e);
            }
            return true;
        }

        @Override
        protected void cleanup() {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.error("Error closing server socket", e);
            }
        }
    }
}

