/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.control.ControlMessageURN;

public class EntityIDRequest
extends AbstractMessage
implements Control {
    private IntComponent simID = new IntComponent("Simulator ID");
    private IntComponent requestID = new IntComponent("Request number");
    private IntComponent count = new IntComponent("Number of IDs");

    public EntityIDRequest(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public EntityIDRequest(int simID, int requestID, int number) {
        this();
        this.simID.setValue(simID);
        this.requestID.setValue(requestID);
        this.count.setValue(number);
    }

    private EntityIDRequest() {
        super(ControlMessageURN.ENTITY_ID_REQUEST);
        this.addMessageComponent(this.simID);
        this.addMessageComponent(this.requestID);
        this.addMessageComponent(this.count);
    }

    public int getSimulatorID() {
        return this.simID.getValue();
    }

    public int getRequestID() {
        return this.requestID.getValue();
    }

    public int getCount() {
        return this.count.getValue();
    }
}

