/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.Property;

public final class EntityTools {
    private EntityTools() {
    }

    public static void copyProperties(Entity from, Entity to) {
        for (Property next : from.getProperties()) {
            Property p = to.getProperty(next.getURN());
            if (p == null) continue;
            p.takeValue(next);
        }
    }

    public static <T extends Entity> List<T> sortedList(Collection<T> input) {
        ArrayList<T> result = input instanceof List ? (ArrayList<T>)input : new ArrayList<T>(input);
        Collections.sort(result, new IDComparator());
        return result;
    }

    public static class IDComparator
    implements Comparator<Entity>,
    Serializable {
        @Override
        public int compare(Entity e1, Entity e2) {
            return e1.getID().getValue() - e2.getID().getValue();
        }
    }
}

