/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;

public final class GeometryTools2D {
    public static final double THRESHOLD = 1.0E-13;

    private GeometryTools2D() {
    }

    public static Point2D getIntersectionPoint(Line2D l1, Line2D l2) {
        double t1 = l1.getIntersection(l2);
        double t2 = l2.getIntersection(l1);
        if (Double.isNaN(t1) || Double.isNaN(t2)) {
            return null;
        }
        return l1.getPoint(t1);
    }

    public static Point2D getSegmentIntersectionPoint(Line2D l1, Line2D l2) {
        double t1 = l1.getIntersection(l2);
        double t2 = l2.getIntersection(l1);
        if (Double.isNaN(t1) || Double.isNaN(t2) || t1 < 0.0 || t1 > 1.0 || t2 < 0.0 || t2 > 1.0) {
            return null;
        }
        return l1.getPoint(t1);
    }

    public static boolean parallel(Line2D l1, Line2D l2) {
        double d = l1.getDirection().getX() * l2.getDirection().getY() - l1.getDirection().getY() * l2.getDirection().getX();
        return GeometryTools2D.nearlyZero(d);
    }

    public static boolean contains(Line2D line, Point2D point) {
        if (GeometryTools2D.nearlyZero(line.getDirection().getX())) {
            double d = point.getX() - line.getOrigin().getX();
            double y = point.getY();
            double yMin = Math.min(line.getOrigin().getY(), line.getEndPoint().getY());
            double yMax = Math.max(line.getOrigin().getY(), line.getEndPoint().getY());
            return GeometryTools2D.nearlyZero(d) && y >= yMin && y <= yMax;
        }
        if (GeometryTools2D.nearlyZero(line.getDirection().getY())) {
            double d = point.getY() - line.getOrigin().getY();
            double x = point.getX();
            double xMin = Math.min(line.getOrigin().getX(), line.getEndPoint().getX());
            double xMax = Math.max(line.getOrigin().getX(), line.getEndPoint().getX());
            return GeometryTools2D.nearlyZero(d) && x >= xMin && x <= xMax;
        }
        double tx = (point.getX() - line.getOrigin().getX()) / line.getDirection().getX();
        double ty = (point.getY() - line.getOrigin().getY()) / line.getDirection().getY();
        if (tx < 0.0 || tx > 1.0 || ty < 0.0 || ty > 1.0) {
            return false;
        }
        double d = tx - ty;
        return GeometryTools2D.nearlyZero(d);
    }

    public static double positionOnLine(Line2D line, Point2D point) {
        double ty;
        if (GeometryTools2D.nearlyZero(line.getDirection().getX())) {
            double d = (point.getY() - line.getOrigin().getY()) / line.getDirection().getY();
            return d;
        }
        if (GeometryTools2D.nearlyZero(line.getDirection().getY())) {
            double d = (point.getX() - line.getOrigin().getX()) / line.getDirection().getX();
            return d;
        }
        double tx = (point.getX() - line.getOrigin().getX()) / line.getDirection().getX();
        double d = tx - (ty = (point.getY() - line.getOrigin().getY()) / line.getDirection().getY());
        if (GeometryTools2D.nearlyZero(d)) {
            return tx;
        }
        return Double.NaN;
    }

    public static double getRightAngleBetweenLines(Line2D first, Line2D second) {
        return GeometryTools2D.getRightAngleBetweenVectors(first.getDirection(), second.getDirection());
    }

    public static double getLeftAngleBetweenLines(Line2D first, Line2D second) {
        return GeometryTools2D.getLeftAngleBetweenVectors(first.getDirection(), second.getDirection());
    }

    public static double getAngleBetweenVectors(Vector2D first, Vector2D second) {
        Vector2D v2;
        Vector2D v1 = first.normalised();
        double cos = v1.dot(v2 = second.normalised());
        if (cos > 1.0) {
            cos = 1.0;
        }
        double angle = Math.toDegrees(Math.acos(cos));
        return angle;
    }

    public static double getRightAngleBetweenVectors(Vector2D first, Vector2D second) {
        double angle = GeometryTools2D.getAngleBetweenVectors(first, second);
        if (GeometryTools2D.isRightTurn(first, second)) {
            return angle;
        }
        return 360.0 - angle;
    }

    public static double getLeftAngleBetweenVectors(Vector2D first, Vector2D second) {
        double angle = GeometryTools2D.getAngleBetweenVectors(first, second);
        if (GeometryTools2D.isRightTurn(first, second)) {
            return 360.0 - angle;
        }
        return angle;
    }

    public static boolean isRightTurn(Line2D first, Line2D second) {
        return GeometryTools2D.isRightTurn(first.getDirection(), second.getDirection());
    }

    public static boolean isRightTurn(Vector2D first, Vector2D second) {
        double t = first.getX() * second.getY() - first.getY() * second.getX();
        return t < 0.0;
    }

    public static boolean nearlyZero(double d) {
        return d > -1.0E-13 && d < 1.0E-13;
    }

    public static double computeArea(List<Point2D> vertices) {
        return Math.abs(GeometryTools2D.computeAreaUnsigned(vertices));
    }

    public static Point2D computeCentroid(List<Point2D> vertices) {
        Point2D last;
        double area = GeometryTools2D.computeAreaUnsigned(vertices);
        Iterator<Point2D> it = vertices.iterator();
        Point2D first = last = it.next();
        double xSum = 0.0;
        double ySum = 0.0;
        while (it.hasNext()) {
            Point2D next = it.next();
            double lastX = last.getX();
            double lastY = last.getY();
            double nextX = next.getX();
            double nextY = next.getY();
            xSum += (lastX + nextX) * (lastX * nextY - nextX * lastY);
            ySum += (lastY + nextY) * (lastX * nextY - nextX * lastY);
            last = next;
        }
        double lastX = last.getX();
        double lastY = last.getY();
        double nextX = first.getX();
        double nextY = first.getY();
        xSum += (lastX + nextX) * (lastX * nextY - nextX * lastY);
        ySum += (lastY + nextY) * (lastX * nextY - nextX * lastY);
        return new Point2D(xSum /= 6.0 * area, ySum /= 6.0 * area);
    }

    public static List<Point2D> vertexArrayToPoints(int[] vertices) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 0; i < vertices.length; i += 2) {
            result.add(new Point2D(vertices[i], vertices[i + 1]));
        }
        return result;
    }

    public static List<Point2D> vertexArrayToPoints(double[] vertices) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 0; i < vertices.length; i += 2) {
            result.add(new Point2D(vertices[i], vertices[i + 1]));
        }
        return result;
    }

    public static List<Line2D> pointsToLines(List<Point2D> points) {
        return GeometryTools2D.pointsToLines(points, false);
    }

    public static List<Line2D> pointsToLines(List<Point2D> points, boolean close) {
        Point2D first;
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        Iterator<Point2D> it = points.iterator();
        Point2D prev = first = it.next();
        while (it.hasNext()) {
            Point2D next = it.next();
            result.add(new Line2D(prev, next));
            prev = next;
        }
        if (close && !prev.equals(first)) {
            result.add(new Line2D(prev, first));
        }
        return result;
    }

    public static Point2D getClosestPoint(Line2D line, Point2D point) {
        Point2D p1 = line.getOrigin();
        Point2D p2 = line.getEndPoint();
        double u = ((point.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (point.getY() - p1.getY()) * (p2.getY() - p1.getY())) / (line.getDirection().getLength() * line.getDirection().getLength());
        return line.getPoint(u);
    }

    public static Point2D getClosestPointOnSegment(Line2D line, Point2D point) {
        Point2D p1 = line.getOrigin();
        Point2D p2 = line.getEndPoint();
        double u = ((point.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (point.getY() - p1.getY()) * (p2.getY() - p1.getY())) / (line.getDirection().getLength() * line.getDirection().getLength());
        if (u <= 0.0) {
            return p1;
        }
        if (u >= 1.0) {
            return p2;
        }
        return line.getPoint(u);
    }

    public static double getDistance(Point2D p1, Point2D p2) {
        return Math.hypot(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static Line2D clipToRectangle(Line2D line, double xMin, double yMin, double xMax, double yMax) {
        double x1 = line.getOrigin().getX();
        double y1 = line.getOrigin().getY();
        double x2 = line.getEndPoint().getX();
        double y2 = line.getEndPoint().getY();
        double tL = (xMin - x1) / (x2 - x1);
        double tR = (xMax - x1) / (x2 - x1);
        double tT = (yMax - y1) / (y2 - y1);
        double tB = (yMin - y1) / (y2 - y1);
        double tMin = 0.0;
        double tMax = 1.0;
        if (x1 < xMin && x2 < xMin || x1 > xMax && x2 > xMax || y1 < yMin && y2 < yMin || y1 > yMax && y2 > yMax) {
            return null;
        }
        if (tL > tMin && tL < tMax) {
            if (x1 < x2) {
                tMin = tL;
            } else {
                tMax = tL;
            }
        }
        if (tR > tMin && tR < tMax) {
            if (x1 > x2) {
                tMin = tR;
            } else {
                tMax = tR;
            }
        }
        if (tT > tMin && tT < tMax) {
            if (y1 > y2) {
                tMin = tT;
            } else {
                tMax = tT;
            }
        }
        if (tB > tMin && tB < tMax) {
            if (y1 < y2) {
                tMin = tB;
            } else {
                tMax = tB;
            }
        }
        if (tMin > tMax) {
            return null;
        }
        return new Line2D(line.getPoint(tMin), line.getPoint(tMax));
    }

    private static double computeAreaUnsigned(List<Point2D> vertices) {
        Point2D last;
        Iterator<Point2D> it = vertices.iterator();
        Point2D first = last = it.next();
        double sum = 0.0;
        while (it.hasNext()) {
            Point2D next = it.next();
            double lastX = last.getX();
            double lastY = last.getY();
            double nextX = next.getX();
            double nextY = next.getY();
            sum += lastX * nextY - nextX * lastY;
            last = next;
        }
        double lastX = last.getX();
        double lastY = last.getY();
        double nextX = first.getX();
        double nextY = first.getY();
        sum += lastX * nextY - nextX * lastY;
        return sum /= 2.0;
    }
}

