/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ScreenTransform {
    private double minX;
    private double minY;
    private double xRange;
    private double yRange;
    private double centreX;
    private double centreY;
    private double zoom;
    private double pixelsPerX;
    private double pixelsPerY;
    private int xOffset;
    private int yOffset;
    private int lastScreenWidth;
    private int lastScreenHeight;
    private Rectangle2D viewBounds;
    private boolean fixedAspectRatio;

    public ScreenTransform(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.xRange = maxX - minX;
        this.yRange = maxY - minY;
        this.centreX = (minX + maxX) / 2.0;
        this.centreY = (minY + maxY) / 2.0;
        this.zoom = 1.0;
        this.fixedAspectRatio = true;
    }

    public void setCentrePoint(double x, double y) {
        this.centreX = x;
        this.centreY = y;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void makeCentreRelativeTo(double x, double y, int screenX, int screenY) {
        int dx = screenX - this.lastScreenWidth / 2;
        int dy = screenY - this.lastScreenHeight / 2;
        this.centreX = x - (double)dx / this.pixelsPerX;
        this.centreY = y + (double)dy / this.pixelsPerY;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void setFixedAspectRatio(boolean b) {
        this.fixedAspectRatio = b;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void zoomIn() {
        this.zoom *= 2.0;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void zoomOut() {
        this.zoom /= 2.0;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void resetZoom() {
        this.zoom = 1.0;
        this.centreX = this.minX + this.xRange / 2.0;
        this.centreY = this.minY + this.yRange / 2.0;
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void show(Rectangle2D bounds) {
        this.centreX = bounds.getMinX() + bounds.getWidth() / 2.0;
        this.centreY = bounds.getMinY() + bounds.getHeight() / 2.0;
        double xZoom = this.xRange / bounds.getWidth();
        double yZoom = this.yRange / bounds.getHeight();
        this.zoom = Math.min(xZoom, yZoom);
        this.rescale(this.lastScreenWidth, this.lastScreenHeight);
    }

    public void rescale(int width, int height) {
        this.xOffset = 0;
        this.yOffset = height;
        this.pixelsPerX = (double)width / this.xRange * this.zoom;
        this.pixelsPerY = (double)height / this.yRange * this.zoom;
        if (this.fixedAspectRatio) {
            if (this.pixelsPerX < this.pixelsPerY) {
                this.pixelsPerY = this.pixelsPerX;
            } else if (this.pixelsPerY < this.pixelsPerX) {
                this.pixelsPerX = this.pixelsPerY;
            }
        }
        int actualCentreX = this.xToScreen(this.centreX);
        this.xOffset = width / 2 - actualCentreX;
        int actualCentreY = this.yToScreen(this.centreY);
        this.yOffset = height + height / 2 - actualCentreY;
        this.lastScreenWidth = width;
        this.lastScreenHeight = height;
        double x1 = this.screenToX(0);
        double x2 = this.screenToX(width);
        double y1 = this.screenToY(height);
        double y2 = this.screenToY(0);
        this.viewBounds = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean isInView(Shape s) {
        if (s == null) {
            return false;
        }
        return s.intersects(this.viewBounds);
    }

    public boolean isInView(Point2D p) {
        if (p == null) {
            return false;
        }
        return this.viewBounds.contains(p);
    }

    public Rectangle2D getViewBounds() {
        return this.viewBounds;
    }

    public int xToScreen(double x) {
        return this.xOffset + (int)Math.round((x - this.minX) * this.pixelsPerX);
    }

    public int yToScreen(double y) {
        return this.yOffset - (int)Math.round((y - this.minY) * this.pixelsPerY);
    }

    public double screenToX(int x) {
        return (double)(x - this.xOffset) / this.pixelsPerX + this.minX;
    }

    public double screenToY(int y) {
        return (double)(this.yOffset - y) / this.pixelsPerY + this.minY;
    }
}

